/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.log;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.kie.server.api.model.Message;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;

public class LogHelper {
    public static void logServerTemplate(Log log, ServerTemplate serverTemplate) {
        log.info((CharSequence)"--- Server Template --- ");
        log.info((CharSequence)("Server Template Id: " + serverTemplate.getId()));
        log.info((CharSequence)("Server Template Name: " + serverTemplate.getName()));
        log.info((CharSequence)("Capabilities: " + serverTemplate.getCapabilities()));
        for (ServerInstanceKey server : serverTemplate.getServerInstanceKeys()) {
            log.info((CharSequence)("  Server: " + server.getUrl()));
        }
        LogHelper.logContainers(log, serverTemplate.getContainersSpec());
        log.info((CharSequence)"----------------------- ");
    }

    public static void logContainers(Log log, Collection<ContainerSpec> containers) {
        for (ContainerSpec container : containers) {
            LogHelper.logContainer(log, container);
        }
    }

    public static void logContainer(Log log, ContainerSpec container) {
        log.info((CharSequence)"  --- Container --- ");
        log.info((CharSequence)("  Container: " + container.getId()));
        log.info((CharSequence)("  Release: " + container.getReleasedId()));
        log.info((CharSequence)("  Status: " + container.getStatus()));
        for (Map.Entry capability : container.getConfigs().entrySet()) {
            log.info((CharSequence)("    Capability: " + ((Capability)capability.getKey()).toString()));
            log.info((CharSequence)("    Config: " + LogHelper.writeConfig((ContainerConfig)capability.getValue())));
        }
        log.info((CharSequence)"  ----------------- ");
    }

    private static String writeConfig(ContainerConfig containerConfig) {
        StringBuilder builder = new StringBuilder("[ ");
        if (containerConfig instanceof ProcessConfig) {
            ProcessConfig processConfig = (ProcessConfig)containerConfig;
            builder.append("runtimeStrategy = ");
            builder.append(processConfig.getRuntimeStrategy());
            builder.append(". kSession = ");
            builder.append(processConfig.getKSession());
            builder.append(". kBase = ");
            builder.append(processConfig.getKBase());
            builder.append(". mergeMode = ");
            builder.append(processConfig.getMergeMode());
        } else if (containerConfig instanceof RuleConfig) {
            RuleConfig ruleConfig = (RuleConfig)containerConfig;
            builder.append("poolInterval = ");
            builder.append(ruleConfig.getPollInterval());
            builder.append(". scannerStatus = ");
            builder.append(ruleConfig.getScannerStatus());
        }
        builder.append(" ]");
        return builder.toString().replaceAll("null", "Default");
    }

    public static String read(List<Message> messageList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Message message : messageList) {
            stringBuilder.append(message.getMessages());
            stringBuilder.append(" on date ");
            stringBuilder.append(message.getTimestamp());
        }
        return stringBuilder.toString();
    }
}

