/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.common;

import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.NotificationServiceFactory;
import org.kie.server.controller.api.service.PersistingServerTemplateStorageService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerHealthCheckControllerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class KieControllerServletListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(KieControllerServletListener.class);
    private KieServerTemplateStorage storage;
    private NotificationService notificationService;
    private KieServerHealthCheckControllerImpl healthCheck = new KieServerHealthCheckControllerImpl();

    public void contextDestroyed(ServletContextEvent event) {
        if (this.storage != null) {
            this.storage.close();
            logger.debug("Template storage {} closed successfully", (Object)this.storage);
        }
        this.healthCheck.stop();
    }

    public void contextInitialized(ServletContextEvent event) {
        ServiceLoader<NotificationServiceFactory> notificationServiceLoader;
        ServiceLoader<PersistingServerTemplateStorageService> storageServices = ServiceLoader.load(PersistingServerTemplateStorageService.class);
        if (storageServices != null && storageServices.iterator().hasNext()) {
            PersistingServerTemplateStorageService storageService = storageServices.iterator().next();
            this.storage = storageService.getTemplateStorage();
            logger.debug("Template storage {} initialized successfully", (Object)this.storage);
        }
        if ((notificationServiceLoader = ServiceLoader.load(NotificationServiceFactory.class)) != null && notificationServiceLoader.iterator().hasNext()) {
            this.notificationService = notificationServiceLoader.iterator().next().getNotificationService();
            logger.debug("Notification service {} initialized successfully", (Object)this.notificationService.toString());
        }
        this.healthCheck.setExecutorService(Executors.newSingleThreadExecutor());
        this.healthCheck.setNotificationService(this.notificationService);
        this.healthCheck.setTemplateStorage(this.storage);
        this.healthCheck.start();
    }
}

