/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.common;

import java.util.ServiceLoader;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.kie.server.controller.api.service.PersistingServerTemplateStorageService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class KieControllerServletListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(KieControllerServletListener.class);
    private KieServerTemplateStorage storage;

    public void contextDestroyed(ServletContextEvent event) {
        if (this.storage != null) {
            this.storage.close();
            logger.debug("Template storage {} closed successfully", (Object)this.storage);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        ServiceLoader<PersistingServerTemplateStorageService> storageServices = ServiceLoader.load(PersistingServerTemplateStorageService.class);
        if (storageServices != null && storageServices.iterator().hasNext()) {
            PersistingServerTemplateStorageService storageService = storageServices.iterator().next();
            this.storage = storageService.getTemplateStorage();
            logger.debug("Template storage {} initialized successfully", (Object)this.storage);
        }
    }
}

