/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.common;

import io.swagger.config.Scanner;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultJaxrsScanner;
import io.swagger.jaxrs.config.SwaggerScannerLocator;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class SwaggerAPIScanner
implements ServletContextListener {
    public static final Boolean SWAGGER_DISABLED = Boolean.parseBoolean(System.getProperty("org.kie.server.controller.swagger.disabled", "false"));
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerAPIScanner.class);

    public void contextInitialized(ServletContextEvent sce) {
        if (SWAGGER_DISABLED.booleanValue()) {
            return;
        }
        LOGGER.info("Starting Swagger API discovery");
        DefaultJaxrsScanner jaxrsScanner = new DefaultJaxrsScanner();
        jaxrsScanner.setPrettyPrint(true);
        SwaggerScannerLocator.getInstance().putScanner("swagger.scanner.id.default", (Scanner)jaxrsScanner);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setBasePath(sce.getServletContext().getContextPath() + "/rest");
        beanConfig.setVersion("7.0");
        beanConfig.setTitle("Controller API");
        beanConfig.setPrettyPrint(true);
        beanConfig.setScan();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

