/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy;

import io.undertow.server.HttpServerExchange;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kie.server.router.ContainerInfo;
import org.kie.server.router.spi.ContainerResolver;

public class DefaultContainerResolver
implements ContainerResolver {
    private Pattern p = Pattern.compile(".*/containers/([^/]+).*");
    private Pattern p2 = Pattern.compile(".*/containers/instances/([^/]+).*");

    @Override
    public String resolveContainerId(HttpServerExchange exchange, Map<String, List<ContainerInfo>> containerInfoPerContainer) {
        String containerId;
        String relativePath = exchange.getRelativePath();
        Matcher matcher = this.p.matcher(relativePath);
        Set<String> knownContainers = containerInfoPerContainer.keySet();
        if (matcher.find() && knownContainers.contains(containerId = matcher.group(1))) {
            return containerId;
        }
        matcher = this.p2.matcher(relativePath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        Deque<String> containerIdQueryParam = exchange.getQueryParameters().get("containerId");
        if (containerIdQueryParam != null && !containerIdQueryParam.isEmpty()) {
            return containerIdQueryParam.getFirst();
        }
        return "NOT_FOUND";
    }

    public String toString() {
        return "Default container resolver";
    }
}

