/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class QueryStringAttribute
implements ExchangeAttribute {
    public static final String QUERY_STRING_SHORT = "%q";
    public static final String QUERY_STRING = "%{QUERY_STRING}";
    public static final String BARE_QUERY_STRING = "%{BARE_QUERY_STRING}";
    public static final ExchangeAttribute INSTANCE = new QueryStringAttribute(true);
    public static final ExchangeAttribute BARE_INSTANCE = new QueryStringAttribute(false);
    private final boolean includeQuestionMark;

    private QueryStringAttribute(boolean includeQuestionMark) {
        this.includeQuestionMark = includeQuestionMark;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        String qs = exchange.getQueryString();
        if (qs.isEmpty() || !this.includeQuestionMark) {
            return qs;
        }
        return '?' + qs;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setQueryString(newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Query String";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(QueryStringAttribute.QUERY_STRING) || token.equals(QueryStringAttribute.QUERY_STRING_SHORT)) {
                return INSTANCE;
            }
            if (token.equals(QueryStringAttribute.BARE_QUERY_STRING)) {
                return BARE_INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

