/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.kie.server.router.Configuration;
import org.kie.server.router.ContainerInfo;

public class ConfigurationMarshaller {
    public String marshall(Configuration configuration) throws Exception {
        JSONArray array;
        Map<String, Set<String>> perContainer = configuration.getHostsPerContainer();
        Map<String, Set<String>> perServer = configuration.getHostsPerServer();
        Map<String, Set<ContainerInfo>> containerInfo = configuration.getContainerInfosPerContainer();
        JSONArray servers = new JSONArray();
        JSONArray containers = new JSONArray();
        JSONArray infos = new JSONArray();
        JSONObject config = new JSONObject();
        for (Map.Entry<String, Set<String>> entry : perContainer.entrySet()) {
            array = new JSONArray();
            entry.getValue().forEach(url -> array.put(url));
            JSONObject container = new JSONObject();
            container.put(entry.getKey(), array);
            containers.put(container);
        }
        for (Map.Entry<String, Set<String>> entry : perServer.entrySet()) {
            array = new JSONArray();
            entry.getValue().forEach(url -> array.put(url));
            JSONObject server = new JSONObject();
            server.put(entry.getKey(), array);
            servers.put(server);
        }
        HashSet processed = new HashSet();
        for (Map.Entry<String, Set<ContainerInfo>> entry : containerInfo.entrySet()) {
            if (processed.contains(entry.getKey())) continue;
            entry.getValue().forEach(ci -> {
                JSONObject jsonCI = new JSONObject();
                processed.add(ci.getAlias());
                processed.add(ci.getContainerId());
                try {
                    jsonCI.put("alias", ci.getAlias());
                    jsonCI.put("containerId", ci.getContainerId());
                    jsonCI.put("releaseId", ci.getReleaseId());
                    infos.put(jsonCI);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            });
        }
        config.put("containers", containers);
        config.put("servers", servers);
        config.put("containerInfo", infos);
        return config.toString(2);
    }

    public Configuration unmarshall(Reader reader) throws Exception {
        Configuration configuration = new Configuration();
        JSONTokener tokener = new JSONTokener(reader);
        JSONObject config = new JSONObject(tokener);
        JSONArray containers = config.getJSONArray("containers");
        for (int i = 0; i < containers.length(); ++i) {
            String[] names;
            JSONObject container = (JSONObject)containers.get(i);
            for (String name : names = JSONObject.getNames(container)) {
                JSONArray urls = (JSONArray)container.get(name);
                if (urls.length() > 0) {
                    for (int j = 0; j < urls.length(); ++j) {
                        String url = urls.get(j).toString();
                        configuration.addContainerHost(name, url);
                    }
                    continue;
                }
                configuration.addEmptyContainerHost(name);
            }
        }
        JSONArray servers = config.getJSONArray("servers");
        for (int i = 0; i < servers.length(); ++i) {
            String[] names;
            JSONObject server = (JSONObject)servers.get(i);
            for (String name : names = JSONObject.getNames(server)) {
                JSONArray urls = (JSONArray)server.get(name);
                if (urls.length() > 0) {
                    for (int j = 0; j < urls.length(); ++j) {
                        String url = urls.get(j).toString();
                        configuration.addServerHost(name, url);
                    }
                    continue;
                }
                configuration.addEmptyServerHost(name);
            }
        }
        JSONArray containerInfo = config.getJSONArray("containerInfo");
        for (int i = 0; i < containerInfo.length(); ++i) {
            JSONObject info = (JSONObject)containerInfo.get(i);
            ContainerInfo actualInfo = new ContainerInfo(info.getString("containerId"), info.getString("alias"), info.getString("releaseId"));
            configuration.addContainerInfo(actualInfo);
        }
        return configuration;
    }
}

