/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.jboss.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kie.server.router.Configuration;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.handlers.ContainersHttpHandler;
import org.kie.server.router.handlers.DocumentsHttpHandler;
import org.kie.server.router.handlers.JobsHttpHandler;
import org.kie.server.router.handlers.KieServerInfoHandler;
import org.kie.server.router.handlers.QueriesDataHttpHandler;
import org.kie.server.router.handlers.QueriesHttpHandler;
import org.kie.server.router.proxy.KieServerProxyClient;
import org.kie.server.router.repository.FileRepository;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.HttpUtils;
import org.kie.server.router.utils.SSLContextBuilder;

public class KieServerRouter {
    private static final String HOST = System.getProperty("org.kie.server.router.host", "localhost");
    private static final int DEFAULT_PORT_NUM = 9000;
    private static final int PORT = Integer.parseInt(System.getProperty("org.kie.server.router.port", String.valueOf(9000)));
    private static final int DEFAULT_PORT_TLS_NUM = 9443;
    private static final int PORT_TLS = Integer.parseInt(System.getProperty("org.kie.server.router.tls.port", String.valueOf(9443)));
    private static final String KEYSTORE_PATH = System.getProperty("org.kie.server.router.tls.keystore");
    private static final String KEYSTORE_PASSWORD = System.getProperty("org.kie.server.router.tls.keystore.password");
    private static final String KEYSTORE_KEYALIAS = System.getProperty("org.kie.server.router.tls.keystore.keyalias");
    private static final boolean TLS_ENABLED = KEYSTORE_PATH != null && !KEYSTORE_PATH.isEmpty();
    private int failedAttemptsInterval = Integer.parseInt(System.getProperty("org.kie.server.controller.retry.interval", "10"));
    private String CONTROLLER = System.getProperty("org.kie.server.controller");
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private static final String SERVER_INFO_JSON = "{\n      \"version\" : \"LATEST\",\n      \"name\" : \"" + KieServerInfoHandler.getRouterName() + "\",\n      \"location\" : \"" + KieServerInfoHandler.getLocationUrl() + "\",\n      \"capabilities\" : [ \"KieServer\", \"BRM\", \"BPM\", \"CaseMgmt\", \"BPM-UI\", \"BRP\" ],\n      \"id\" : \"" + KieServerInfoHandler.getRouterId() + "\"\n}";
    private ServiceLoader<ConfigRepository> configRepositoryServiceLoader = ServiceLoader.load(ConfigRepository.class);
    private Undertow server;
    private ConfigRepository repository = new FileRepository();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> controllerConnectionAttempts;

    public KieServerRouter() {
        this.configRepositoryServiceLoader.forEach(repo -> {
            this.repository = repo;
        });
        log.info("KIE Server router repository implementation is " + this.repository);
    }

    public static void main(String[] args) {
        final KieServerRouter router = new KieServerRouter();
        router.start(HOST, (Integer)PORT, PORT_TLS, new ConfigurationListener[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                router.stop();
            }
        });
    }

    public void start(String host, Integer port, ConfigurationListener ... listeners) {
        this.start(host, port, 9443, listeners);
    }

    public void start(String host, Integer port, Integer portTls, ConfigurationListener ... listeners) {
        System.setProperty("org.kie.server.router.host", host);
        System.setProperty("org.kie.server.router.port", port.toString());
        System.setProperty("org.kie.server.router.tls.port", portTls.toString());
        Configuration configuration = this.repository.load();
        for (ConfigurationListener listener : listeners) {
            configuration.addListener(listener);
        }
        AdminHttpHandler adminHandler = new AdminHttpHandler(configuration, this.repository, this.executorService);
        KieServerProxyClient proxyClient = new KieServerProxyClient(configuration, adminHandler);
        Map<String, List<String>> perContainer = configuration.getHostsPerContainer();
        for (Map.Entry entry : perContainer.entrySet()) {
            LinkedHashSet uniqueUrls = new LinkedHashSet((Collection)entry.getValue());
            uniqueUrls.forEach(url -> proxyClient.addContainer((String)entry.getKey(), URI.create(url)));
        }
        ResponseCodeHandler notFoundHandler = ResponseCodeHandler.HANDLE_404;
        ProxyHandler proxyHandler = new ProxyHandler(proxyClient, -1, notFoundHandler, true, false);
        PathHandler pathHandler = Handlers.path(proxyHandler);
        pathHandler.addPrefixPath("/queries/definitions", new QueriesDataHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/queries", new QueriesHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/jobs", new JobsHttpHandler(proxyHandler, adminHandler));
        pathHandler.addPrefixPath("/documents", new DocumentsHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addExactPath("/containers", new ContainersHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/mgmt", adminHandler);
        pathHandler.addExactPath("/", new KieServerInfoHandler());
        BlockingHandler blockingHandler = new BlockingHandler(pathHandler);
        Undertow.Builder undertowBuilder = Undertow.builder().addHttpListener(port, host);
        if (TLS_ENABLED) {
            SSLContext sslContext = SSLContextBuilder.builder().setKeyStorePath(KEYSTORE_PATH).setKeyStorePassword(KEYSTORE_PASSWORD).setKeyAlias(KEYSTORE_KEYALIAS).build();
            undertowBuilder = undertowBuilder.addHttpsListener(portTls, host, sslContext);
        }
        this.server = undertowBuilder.setHandler(blockingHandler).build();
        this.server.start();
        if (TLS_ENABLED) {
            log.infof("KieServerRouter started on %s:%s and %s:%s (TLS) at %s", host, port, host, portTls, new Date());
        } else {
            log.infof("KieServerRouter started on %s:%s at %s", (Object)host, (Object)port, (Object)new Date());
        }
        this.connectToController(adminHandler);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean clean) {
        this.executorService.shutdownNow();
        this.disconnectToController();
        if (this.server != null) {
            this.server.stop();
            this.repository.close();
            if (clean) {
                this.repository.clean();
            }
            log.infof("KieServerRouter stopped on %s:%s at %s", (Object)System.getProperty("org.kie.server.router.host"), (Object)System.getProperty("org.kie.server.router.port"), (Object)new Date());
        } else {
            log.error("KieServerRouter was not started");
        }
    }

    protected void connectToController(AdminHttpHandler adminHandler) {
        if (this.CONTROLLER == null) {
            return;
        }
        try {
            String jsonResponse = HttpUtils.putHttpCall(this.CONTROLLER + "/server/" + KieServerInfoHandler.getRouterId(), SERVER_INFO_JSON);
            log.debugf("Controller response :: ", (Object)jsonResponse);
            this.boostrapFromControllerResponse(jsonResponse, adminHandler);
            log.infof("KieServerRouter connected to controller at " + this.CONTROLLER, new Object[0]);
        }
        catch (Exception e) {
            log.error("Error when connecting to controller at " + this.CONTROLLER + " due to " + e.getMessage());
            log.debug(e);
            this.controllerConnectionAttempts = this.executorService.scheduleAtFixedRate(() -> {
                try {
                    String jsonResponse = HttpUtils.putHttpCall(this.CONTROLLER + "/server/" + KieServerInfoHandler.getRouterId(), SERVER_INFO_JSON);
                    log.debugf("Controller response :: ", (Object)jsonResponse);
                    this.boostrapFromControllerResponse(jsonResponse, adminHandler);
                    this.controllerConnectionAttempts.cancel(false);
                    log.infof("KieServerRouter connected to controller at " + this.CONTROLLER, new Object[0]);
                }
                catch (Exception ex) {
                    log.error("Error when connecting to controller at " + this.CONTROLLER + " next attempt in " + this.failedAttemptsInterval + " " + TimeUnit.SECONDS.toString());
                    log.debug(ex);
                }
            }, this.failedAttemptsInterval, this.failedAttemptsInterval, TimeUnit.SECONDS);
        }
    }

    protected void disconnectToController() {
        if (this.CONTROLLER == null) {
            return;
        }
        try {
            HttpUtils.deleteHttpCall(this.CONTROLLER + "/server/" + KieServerInfoHandler.getRouterId() + "/?location=" + URLEncoder.encode(KieServerInfoHandler.getLocationUrl(), "UTF-8"));
            log.infof("KieServerRouter disconnected from controller at " + this.CONTROLLER, new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error when disconnecting from controller at " + this.CONTROLLER), e);
        }
    }

    protected void boostrapFromControllerResponse(String jsonResponse, AdminHttpHandler adminHandler) throws JSONException {
        ArrayList<String> containers = new ArrayList<String>();
        JSONObject serverConfig = new JSONObject(jsonResponse);
        try {
            JSONArray sourceList = serverConfig.getJSONArray("containers");
            for (int i = 0; i < sourceList.length(); ++i) {
                JSONObject container = sourceList.getJSONObject(i);
                containers.add(container.getString("container-id"));
            }
        }
        catch (JSONException e) {
            log.debug((Object)("Error when getting list of containers:: " + e.getMessage()), e);
        }
        adminHandler.addControllerContainers(containers);
    }
}

