/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.generator;

import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.cases.CaseFile;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.generator.CaseIdBaseIntegrationTest;
import org.kie.server.integrationtests.shared.KieServerDeployer;

public class CustomCaseIdIntegrationTest
extends CaseIdBaseIntegrationTest {
    private static org.kie.server.api.model.ReleaseId releaseId = new org.kie.server.api.model.ReleaseId("org.kie.server.testing", "case-insurance", "1.0.0.Final");
    private static final String CASE_HR_DEF_ID = "UserTaskCase";
    private static final String PREFIX_VARIABLE_LOWER_CAPITALIZE = "EmptyCaseIdExpressionPrefixVariableLowerCapitalize";
    private static final String CONTAINER_ID = "insurance";
    private static final String CASE_OWNER_ROLE = "owner";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/case-insurance");
        kieContainer = KieServices.Factory.get().newKieContainer((ReleaseId)releaseId);
        CustomCaseIdIntegrationTest.createContainer((String)CONTAINER_ID, (org.kie.server.api.model.ReleaseId)releaseId);
    }

    @Test
    public void testCustomCaseId() {
        Assume.assumeFalse((boolean)TestConfig.isLocalServer());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "first case started");
        CaseFile caseFile = CaseFile.builder().addUserAssignments(CASE_OWNER_ROLE, "yoda").data(data).build();
        String caseId = this.caseClient.startCase(CONTAINER_ID, CASE_HR_DEF_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertTrue((String)("Created Case Id doesn't start with expected value, value is: " + caseId), (boolean)caseId.startsWith("HR-01234"));
    }

    @Test
    public void testCustomCaseIdWithOptionalParams() {
        Assume.assumeFalse((boolean)TestConfig.isLocalServer());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("var1", "VALUE1");
        data.put("country", "spa");
        CaseFile caseFile = CaseFile.builder().addUserAssignments(CASE_OWNER_ROLE, "yoda").data(data).build();
        String caseId = this.caseClient.startCase(CONTAINER_ID, PREFIX_VARIABLE_LOWER_CAPITALIZE, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertTrue((String)("Created Case Id doesn't match expected value, value is: " + caseId), (boolean)caseId.matches("insurance-value1-Spa-01234[0-9]+"));
    }

    @Test
    public void testCustomCaseIdWithoutParamsThrowsException() {
        Assume.assumeFalse((boolean)TestConfig.isLocalServer());
        CaseFile caseFile = CaseFile.builder().addUserAssignments(CASE_OWNER_ROLE, "yoda").data(Collections.emptyMap()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseClient.startCase(CONTAINER_ID, PREFIX_VARIABLE_LOWER_CAPITALIZE, caseFile)).isInstanceOf(KieServicesException.class)).hasMessageContaining("Case Id Prefix cannot be generated");
    }
}

