/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.config.TestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerDeployer {
    protected static Logger logger = LoggerFactory.getLogger(KieServerDeployer.class);
    private static KieMavenRepository repository;
    private static boolean commonParentDeployed;

    public static void buildAndDeployMavenProject(String basedir) {
        logger.debug("Building and deploying Maven project from basedir '{}'.", (Object)basedir);
        ClassLoader classLoaderBak = Thread.currentThread().getContextClassLoader();
        System.setProperty("maven.multiModuleProjectDirectory", basedir);
        MavenCli cli = new MavenCli();
        ArrayList<String> mvnArgs = TestConfig.isLocalServer() ? new ArrayList<String>(Arrays.asList("-B", "clean", "install")) : new ArrayList<String>(Arrays.asList("-B", "-e", "clean", "deploy"));
        String kjarsBuildSettingsXml = TestConfig.getKjarsBuildSettingsXml();
        if (kjarsBuildSettingsXml != null && !kjarsBuildSettingsXml.isEmpty()) {
            mvnArgs.add("-s");
            mvnArgs.add(kjarsBuildSettingsXml);
        }
        int mvnRunResult = cli.doMain(mvnArgs.toArray(new String[mvnArgs.size()]), basedir, System.out, System.err);
        Thread.currentThread().setContextClassLoader(classLoaderBak);
        if (mvnRunResult != 0) {
            throw new RuntimeException("Error while building Maven project from basedir " + basedir + ". Return code=" + mvnRunResult);
        }
        logger.debug("Maven project successfully built and deployed!");
    }

    public static void buildAndDeployCommonMavenParent() {
        if (!commonParentDeployed) {
            KieServerDeployer.buildAndDeployMavenProject(ClassLoader.class.getResource("/kjars-sources/common-parent").getFile());
        } else {
            logger.debug("Common parent project already deployed, nothing to do here.");
        }
    }

    public static void createAndDeployKJar(ReleaseId releaseId) {
        String drl = "package org.pkg1\nglobal java.util.List list;declare Message\n    text : String\nend\nrule echo dialect \"mvel\"\nwhen\n    $m : Message()\nthen\n    $m.text = \"echo:\" + $m.text;\nend\nrule X when\n    msg : String()\nthen\n    list.add(msg);\nend\n";
        KieServerDeployer.createAndDeployKJar(releaseId, Collections.singletonMap("src/main/resources/org/pkg1/r0.drl", drl));
    }

    public static void createAndDeployKJar(ReleaseId releaseId, Map<String, String> files) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)releaseId);
        for (Map.Entry<String, String> file : files.entrySet()) {
            kfs.write(file.getKey(), file.getValue());
        }
        byte[] pom = kfs.read("pom.xml");
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertFalse((String)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), (boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule((org.kie.api.builder.ReleaseId)releaseId);
        byte[] jar = kieModule.getBytes();
        KieServerDeployer.getRepository().installArtifact((AFReleaseId)releaseId, jar, pom);
        ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)releaseId);
    }

    public static void removeLocalArtifact(ReleaseId releaseId) {
        String originalMavenSettings = System.getProperty("kie.maven.settings.custom");
        String kieServerMavenSettings = TestConfig.getKieServerMavenSettings();
        System.setProperty("kie.maven.settings.custom", kieServerMavenSettings);
        MavenSettings.reinitSettings();
        KieServerDeployer.getRepository().removeLocalArtifact((AFReleaseId)releaseId);
        System.setProperty("kie.maven.settings.custom", originalMavenSettings);
        MavenSettings.reinitSettings();
    }

    public static MavenRepository getRepository() {
        if (repository == null) {
            KieServices ks = KieServices.Factory.get();
            ReleaseId initReleaseId = new ReleaseId("org.kie.server.initial", "init-maven-repo", "42");
            KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)initReleaseId);
            byte[] pom = kfs.read("pom.xml");
            MavenProject minimalMavenProject = MavenProjectLoader.parseMavenPom((InputStream)new ByteArrayInputStream(pom));
            repository = KieMavenRepository.getKieMavenRepository((MavenProject)minimalMavenProject);
        }
        return repository;
    }

    static {
        commonParentDeployed = false;
    }
}

