/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessExecutor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ProcessExecutor.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(2);

    public boolean executeProcessCommand(String command) {
        return this.executeProcessCommand(command, null);
    }

    public boolean executeProcessCommand(String command, Path directory) {
        Consumer<String> outputConsumer = arg_0 -> ((Logger)logger).info(arg_0);
        return this.executeProcessCommand(command, outputConsumer, directory);
    }

    private boolean executeProcessCommand(String command, Consumer<String> outputConsumer, Path directory) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
            if (directory != null) {
                processBuilder = processBuilder.directory(directory.toFile());
            }
            Process process = processBuilder.start();
            Future<?> osFuture = this.executorService.submit(new ProcessOutputReader(process.getInputStream(), outputConsumer));
            Future<?> esFuture = this.executorService.submit(new ProcessOutputReader(process.getErrorStream(), outputConsumer));
            int exitValue = process.waitFor();
            osFuture.get();
            esFuture.get();
            return exitValue == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for process to finish.", e);
        }
        catch (IOException | ExecutionException e) {
            throw new RuntimeException("Error executing command " + command, e);
        }
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }

    private final class ProcessOutputReader
    implements Runnable {
        private InputStream fromStream;
        Consumer<String> outputConsumer;

        private ProcessOutputReader(InputStream fromStream, Consumer<String> outputConsumer) {
            this.fromStream = fromStream;
            this.outputConsumer = outputConsumer;
        }

        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.fromStream);
            try (BufferedReader br = new BufferedReader(isr);){
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.outputConsumer.accept(line);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error reading from stream!", ioe);
            }
        }
    }
}

