/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import org.kie.api.command.Command;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.JobServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.client.SolverServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.integrationtests.controller.client.KieServerMgmtControllerClient;

public class KieServerSynchronization {
    private static final long SERVICE_TIMEOUT = 30000L;
    private static final long TIMEOUT_BETWEEN_CALLS = 200L;

    public static void waitForJobToFinish(JobServicesClient jobServicesClient, Long jobId) throws Exception {
        KieServerSynchronization.waitForJobToFinish(jobServicesClient, jobId, 30000L);
    }

    public static void waitForJobToFinish(JobServicesClient jobServicesClient, Long jobId, Long timeOut) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            RequestInfoInstance result = jobServicesClient.getRequestById(jobId, false, false);
            return STATUS.CANCELLED.toString().equals(result.getStatus()) || STATUS.DONE.toString().equals(result.getStatus()) || STATUS.ERROR.toString().equals(result.getStatus());
        }, timeOut);
    }

    public static void waitForKieServerSynchronization(KieServicesClient client, int numberOfExpectedContainers) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServiceResponse containersList = client.listContainers();
            if (((KieContainerResourceList)containersList.getResult()).getContainers() == null) {
                if (numberOfExpectedContainers == 0) {
                    return true;
                }
            } else if (numberOfExpectedContainers == ((KieContainerResourceList)containersList.getResult()).getContainers().size()) {
                boolean containersInitializing = false;
                for (KieContainerResource container : ((KieContainerResourceList)containersList.getResult()).getContainers()) {
                    if (!KieContainerStatus.CREATING.equals((Object)container.getStatus()) && !KieContainerStatus.DISPOSING.equals((Object)container.getStatus())) continue;
                    containersInitializing = true;
                }
                if (!containersInitializing) {
                    return true;
                }
            }
            return false;
        });
    }

    public static void waitForKieServerMessage(KieServicesClient client, String containerId, String expectedMessage) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServiceResponse containerResponse = client.getContainerInfo(containerId);
            if (!containerResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return false;
            }
            List messagesList = ((KieContainerResource)containerResponse.getResult()).getMessages();
            if (messagesList.size() == 1) {
                return ((Message)messagesList.get(0)).getMessages().stream().anyMatch(n -> n.equals(expectedMessage));
            }
            return false;
        });
    }

    public static void waitForProcessInstanceToFinish(ProcessServicesClient processClient, String containerId, long processInstanceId) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ProcessInstance processInstance = processClient.getProcessInstance(containerId, Long.valueOf(processInstanceId));
            return Integer.valueOf(2).equals(processInstance.getState()) || Integer.valueOf(3).equals(processInstance.getState());
        });
    }

    public static void waitForProcessInstanceStart(QueryServicesClient queryClient, String containerId) throws Exception {
        KieServerSynchronization.waitForProcessInstanceStart(queryClient, containerId, 1, Arrays.asList(1));
    }

    public static void waitForProcessInstanceStart(QueryServicesClient queryClient, String containerId, int expectedInstances, List<Integer> statuses) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            List processInstances = queryClient.findProcessInstancesByContainerId(containerId, statuses, Integer.valueOf(0), Integer.valueOf(100));
            return processInstances.size() == expectedInstances;
        });
    }

    public static void waitForContainerWithReleaseId(KieServicesClient client, ReleaseId releaseId) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ReleaseIdFilter releaseIdFilter = new ReleaseIdFilter(releaseId);
            KieContainerResourceFilter resourceFilter = new KieContainerResourceFilter(releaseIdFilter);
            ServiceResponse containersList = client.listContainers(resourceFilter);
            List containers = ((KieContainerResourceList)containersList.getResult()).getContainers();
            return containers != null && !containers.isEmpty();
        });
    }

    public static void waitForContainerWithScannerStatus(KieServicesClient client, KieScannerStatus scannerStatus) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServiceResponse containersList = client.listContainers();
            List containers = ((KieContainerResourceList)containersList.getResult()).getContainers();
            if (containers != null) {
                for (KieContainerResource container : containers) {
                    KieScannerResource scanner = container.getScanner();
                    if (scanner == null || !scannerStatus.equals((Object)scanner.getStatus())) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public static void waitForSolver(SolverServicesClient client, String containerId, String solverId) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            List solverInstanceList = client.getSolvers(containerId);
            for (SolverInstance solver : solverInstanceList) {
                if (!solverId.equals(solver.getSolverId())) continue;
                return true;
            }
            return false;
        });
    }

    public static void waitForSolverDispose(SolverServicesClient client, String containerId, String solverId) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            List solverInstanceList = client.getSolvers(containerId);
            for (SolverInstance solver : solverInstanceList) {
                if (!solverId.equals(solver.getSolverId())) continue;
                return false;
            }
            return true;
        });
    }

    public static void waitForSolverStatus(SolverServicesClient client, String containerId, String solverId, SolverInstance.SolverStatus status) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            SolverInstance solverInstance = client.getSolver(containerId, solverId);
            return status.equals((Object)solverInstance.getStatus());
        });
    }

    public static void waitForCommandResult(RuleServicesClient client, String containerId, Command command, String identifier, Object value) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServiceResponse response = client.executeCommandsWithResults(containerId, command);
            ExecutionResults result = (ExecutionResults)response.getResult();
            return value.equals(result.getValue(identifier));
        });
    }

    public static void waitForTaskStatus(UserTaskServicesClient client, Long taskId, String status) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            TaskInstance task = client.findTaskById(taskId);
            return status.equals(task.getStatus());
        });
    }

    public static void waitForQuery(QueryServicesClient client, QueryDefinition query) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            try {
                QueryDefinition q = client.getQuery(query.getName());
                return query.getExpression().equals(q.getExpression());
            }
            catch (KieServicesException e) {
                return false;
            }
        });
    }

    public static void waitForQueryRemoval(QueryServicesClient client, QueryDefinition query) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            try {
                client.getQuery(query.getName());
                return false;
            }
            catch (KieServicesException e) {
                return true;
            }
        });
    }

    public static void waitForServerInstanceSynchronization(KieServerMgmtControllerClient controllerClient, String serverTemplateId, int numberOfExpectedServerInstances) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServerTemplate serverTemplate = controllerClient.getServerTemplate(serverTemplateId);
            return serverTemplate != null && serverTemplate.getServerInstanceKeys().size() == numberOfExpectedServerInstances;
        });
    }

    public static void waitForKieServerScannerStatus(KieServicesClient client, String containerId, KieScannerStatus scannerStatus) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServiceResponse containerResponse = client.getContainerInfo(containerId);
            if (!containerResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return false;
            }
            KieScannerResource scanner = ((KieContainerResource)containerResponse.getResult()).getScanner();
            return scanner.getStatus().equals((Object)scannerStatus);
        });
    }

    public static void waitForKieServerScannerStatus(KieServicesClient client, String containerId, KieScannerStatus scannerStatus, Long pollInterval) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServiceResponse containerResponse = client.getContainerInfo(containerId);
            if (!containerResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return false;
            }
            KieScannerResource scanner = ((KieContainerResource)containerResponse.getResult()).getScanner();
            return scanner.getStatus().equals((Object)scannerStatus) && scanner.getPollInterval().equals(pollInterval);
        });
    }

    public static void waitForKieServerConfig(KieServicesClient client, String containerId, String configItemName, String configItemValue) throws Exception {
        KieServerSynchronization.waitForCondition(() -> {
            ServiceResponse containerResponse = client.getContainerInfo(containerId);
            if (!containerResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return false;
            }
            List configItems = ((KieContainerResource)containerResponse.getResult()).getConfigItems();
            for (KieServerConfigItem configItem : configItems) {
                if (!configItem.getName().equals(configItemName) || !configItem.getValue().equals(configItemValue)) continue;
                return true;
            }
            return false;
        });
    }

    private static void waitForCondition(BooleanSupplier condition) throws Exception {
        KieServerSynchronization.waitForCondition(condition, 30000L);
    }

    private static void waitForCondition(BooleanSupplier condition, long timeOut) throws Exception {
        long timeoutTime = Calendar.getInstance().getTimeInMillis() + timeOut;
        while (Calendar.getInstance().getTimeInMillis() < timeoutTime) {
            if (condition.getAsBoolean()) {
                return;
            }
            Thread.sleep(200L);
        }
        throw new TimeoutException("Synchronization failed for defined timeout: " + timeOut + " milliseconds.");
    }
}

