/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.stream.Stream;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.KieServerRouter;

public class KieServerRouterExecutor {
    protected KieServerRouter router;
    private File repository;

    public void startKieRouter() {
        if (!TestConfig.startRouter()) {
            return;
        }
        if (this.router != null) {
            throw new RuntimeException("Kie server router is already created!");
        }
        this.repository = new File("target/router-repo");
        this.repository.mkdirs();
        System.setProperty("org.kie.server.router.repo", this.repository.getAbsolutePath());
        Integer port = this.getRouterPort();
        this.router = new KieServerRouter();
        this.router.start("localhost", port, new ConfigurationListener[0]);
        if (System.getProperty("org.kie.server.router") == null) {
            System.setProperty("org.kie.server.router", "http://localhost:" + port);
        }
    }

    public void stopKieRouter() {
        if (!TestConfig.startRouter()) {
            return;
        }
        if (this.router == null) {
            throw new RuntimeException("Kie execution controller is already stopped!");
        }
        System.clearProperty("org.kie.server.router.repo");
        this.router.stop(true);
        this.router = null;
        Stream.of(this.repository.listFiles()).forEach(f -> f.delete());
        this.repository.delete();
    }

    protected Integer getRouterPort() {
        String routerUrl = System.getProperty("org.kie.server.router");
        if (routerUrl == null) {
            return TestConfig.getRouterAllocatedPort();
        }
        try {
            URL url = new URL(routerUrl);
            return url.getPort();
        }
        catch (MalformedURLException e) {
            return TestConfig.getRouterAllocatedPort();
        }
    }
}

