/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.KieServerReflections;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestJmsSharedBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    @Parameterized.Parameter(value=1)
    public KieServicesConfiguration configuration;
    protected static KieCommands commandsFactory;
    protected static KieContainer kieContainer;
    protected static final String PERSON_CLASS_NAME = "org.jbpm.data.Person";
    protected static final String CUSTOM_PARAM_CLASS_NAME = "org.jbpm.data.CustomParameter";

    @Parameterized.Parameters(name="{0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesRestConfiguration();
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB, restConfiguration}, {MarshallingFormat.JSON, restConfiguration}, {MarshallingFormat.XSTREAM, restConfiguration}));
        if (TestConfig.getRemotingUrl() != null && !TestConfig.skipJMS()) {
            KieServicesConfiguration jmsConfiguration = RestJmsSharedBaseIntegrationTest.createKieServicesJmsConfiguration();
            parameterData.addAll(Arrays.asList({MarshallingFormat.JAXB, jmsConfiguration}, {MarshallingFormat.JSON, jmsConfiguration}, {MarshallingFormat.XSTREAM, jmsConfiguration}));
        }
        return parameterData;
    }

    @Override
    protected KieServicesClient createDefaultClient() throws Exception {
        this.addExtraCustomClasses(this.extraClasses);
        if (TestConfig.isLocalServer()) {
            this.configuration = KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), null, null);
        }
        return this.createDefaultClient(this.configuration, this.marshallingFormat);
    }

    protected Object createInstance(String objectClassIdentifier, Object ... constructorParameters) {
        return KieServerReflections.createInstance(objectClassIdentifier, ((Class)this.extraClasses.get(objectClassIdentifier)).getClassLoader(), constructorParameters);
    }

    protected Object createPersonInstance(String name) {
        return this.createInstance(PERSON_CLASS_NAME, name);
    }

    protected Object createCustomParameterInstance(String name, long value) {
        return this.createInstance(CUSTOM_PARAM_CLASS_NAME, name, value);
    }

    protected void changeUser(String username) throws Exception {
        if (username == null) {
            username = TestConfig.getUsername();
        }
        this.configuration.setUserName(username);
        this.client = this.createDefaultClient();
    }

    protected static KieServicesConfiguration createKieServicesJmsConfiguration() {
        try {
            InitialContext context = TestConfig.getInitialRemoteContext();
            Queue requestQueue = (Queue)context.lookup(TestConfig.getRequestQueueJndi());
            Queue responseQueue = (Queue)context.lookup(TestConfig.getResponseQueueJndi());
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(TestConfig.getConnectionFactory());
            KieServicesConfiguration jmsConfiguration = KieServicesFactory.newJMSConfiguration((ConnectionFactory)connectionFactory, (Queue)requestQueue, (Queue)responseQueue, (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
            return jmsConfiguration;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create JMS client configuration!", e);
        }
    }

    protected static KieServicesConfiguration createKieServicesRestConfiguration() {
        return KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    }

    protected void assertClientException(ThrowableAssert.ThrowingCallable callable, int expectedHttpCode, String message) {
        this.assertClientException(callable, expectedHttpCode, message, message);
    }

    protected void assertClientException(ThrowableAssert.ThrowingCallable callable, int expectedHttpCode, String restMessage, String jmsMessage) {
        if (this.configuration.isRest()) {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(KieServicesHttpException.class)).hasFieldOrPropertyWithValue("httpCode", (Object)expectedHttpCode)).hasMessageContaining(restMessage);
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(KieServicesException.class)).hasMessageContaining(jmsMessage);
        }
    }

    protected List<ExecutionErrorInstance> filterErrorsByProcessId(Collection<ExecutionErrorInstance> errors, String processId) {
        return errors.stream().filter(error -> processId.equals(error.getProcessId())).collect(Collectors.toList());
    }

    protected List<ExecutionErrorInstance> filterErrorsByProcessInstanceId(Collection<ExecutionErrorInstance> errors, Long processInstanceId) {
        return errors.stream().filter(error -> processInstanceId.equals(error.getProcessInstanceId())).collect(Collectors.toList());
    }
}

