/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.BasicAuthentication;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestOnlyBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    @Parameterized.Parameter(value=1)
    public KieServicesConfiguration configuration;
    private static Client httpClient;

    @Parameterized.Parameters(name="{0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = RestOnlyBaseIntegrationTest.createKieServicesRestConfiguration();
        return Arrays.asList({MarshallingFormat.JAXB, restConfiguration}, {MarshallingFormat.JSON, restConfiguration});
    }

    @Override
    protected KieServicesClient createDefaultClient() throws Exception {
        if (TestConfig.isLocalServer()) {
            this.configuration = KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), null, null);
        }
        return this.createDefaultClient(this.configuration, this.marshallingFormat);
    }

    protected MediaType getMediaType() {
        switch (this.marshallingFormat) {
            case JAXB: {
                return MediaType.APPLICATION_XML_TYPE;
            }
            case JSON: {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            case XSTREAM: {
                return MediaType.APPLICATION_XML_TYPE;
            }
        }
        throw new RuntimeException("Unrecognized marshalling format: " + this.marshallingFormat);
    }

    protected void changeUser(String username, String password) throws Exception {
        if (username == null) {
            username = TestConfig.getUsername();
        }
        if (password == null) {
            password = TestConfig.getPassword();
        }
        this.configuration.setUserName(username);
        this.configuration.setPassword(password);
        this.client = this.createDefaultClient();
        this.closeHttpClient();
    }

    protected WebTarget newRequest(String uriString) {
        if (httpClient == null) {
            httpClient = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(10L, TimeUnit.SECONDS).build();
        }
        WebTarget webTarget = httpClient.target(uriString);
        webTarget.register((Object)new BasicAuthentication(this.configuration.getUserName(), this.configuration.getPassword()));
        return webTarget;
    }

    private void closeHttpClient() {
        httpClient.close();
        httpClient = null;
    }

    protected <T> Entity<T> createEntity(T requestObject) {
        return Entity.entity(requestObject, (MediaType)this.getMediaType());
    }

    protected static KieServicesConfiguration createKieServicesRestConfiguration() {
        return KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    }
}

