/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.server.controller.client.event.EventHandler;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerExecutor;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WebSocketKieControllerNotificationIntegrationTest
extends KieServerBaseIntegrationTest {
    private static final ReleaseId releaseId = new ReleaseId("org.kie.server.testing", "stateless-session-kjar", "1.0.0");
    private static final String CONTAINER_ID = "kie-concurrent";
    private static final String CONTAINER_NAME = "containerName";
    KieServerControllerClient controllerClient;
    EventHandler eventHandler;

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar");
    }

    protected KieServicesClient createDefaultClient() {
        return null;
    }

    @Before
    public void setup() throws Exception {
        super.setup();
        WebSocketKieControllerNotificationIntegrationTest.disposeAllContainers();
        this.disposeAllServerInstances();
        this.eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        this.controllerClient = TestConfig.isLocalServer() ? KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), null, null, (EventHandler)this.eventHandler) : KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword(), (EventHandler)this.eventHandler);
    }

    @After
    public void closeControllerClient() {
        if (this.controllerClient != null) {
            try {
                logger.info("Closing Kie Server Management Controller client");
                this.controllerClient.close();
            }
            catch (IOException e) {
                logger.error("Error trying to close Kie Server Management Controller Client: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Test(timeout=30000L)
    public void testServerTemplateEvents() throws Exception {
        this.runAsync(() -> {
            ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
            Assert.assertNotNull((Object)instanceList);
            KieServerAssert.assertNullOrEmpty((String)"Active kie server instance found!", (Object[])instanceList.getServerTemplates());
            ServerTemplate template = new ServerTemplate("notification-int-test", "Notification Test Server");
            this.controllerClient.saveServerTemplate(template);
            instanceList = this.controllerClient.listServerTemplates();
            Assert.assertNotNull((Object)instanceList);
            Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
            this.controllerClient.deleteServerTemplate(template.getId());
        });
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onServerTemplateUpdated((ServerTemplateUpdated)Mockito.any());
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onServerTemplateDeleted((ServerTemplateDeleted)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    @Ignore(value="Skipped due to race condition between embedded Kie server initialization and Kie server healthcheck.")
    public void testKieServerEvents() throws Exception {
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertNotNull((Object)instanceList);
        KieServerAssert.assertNullOrEmpty((String)"Active kie server instance found!", (Object[])instanceList.getServerTemplates());
        server = new KieServerExecutor();
        server.startKieServer();
        try {
            instanceList = this.controllerClient.listServerTemplates();
            Assert.assertNotNull((Object)instanceList);
            Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onServerTemplateUpdated((ServerTemplateUpdated)Mockito.any());
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onServerInstanceUpdated((ServerInstanceUpdated)Mockito.any());
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onServerInstanceConnected((ServerInstanceConnected)Mockito.any());
            ServerTemplate template = instanceList.getServerTemplates()[0];
            ContainerSpec containerSpec = new ContainerSpec(CONTAINER_ID, CONTAINER_NAME, (ServerTemplateKey)template, releaseId, KieContainerStatus.STOPPED, Collections.emptyMap());
            this.controllerClient.saveContainerSpec(template.getId(), containerSpec);
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L).times(2))).onServerTemplateUpdated((ServerTemplateUpdated)Mockito.any());
            this.controllerClient.startContainer((ContainerSpecKey)containerSpec);
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onContainerSpecUpdated((ContainerSpecUpdated)Mockito.any());
            this.controllerClient.stopContainer((ContainerSpecKey)containerSpec);
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L).times(2))).onContainerSpecUpdated((ContainerSpecUpdated)Mockito.any());
            this.controllerClient.deleteContainerSpec(template.getId(), containerSpec.getId());
            ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L).times(3))).onServerTemplateUpdated((ServerTemplateUpdated)Mockito.any());
        }
        finally {
            server.stopKieServer();
        }
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onServerInstanceDeleted((ServerInstanceDeleted)Mockito.any());
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L).times(4))).onServerTemplateUpdated((ServerTemplateUpdated)Mockito.any());
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.timeout((long)2000L))).onServerInstanceDisconnected((ServerInstanceDisconnected)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    protected void runAsync(Runnable runnable) throws Exception {
        Executors.newSingleThreadExecutor().submit(runnable).get();
    }
}

