/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.jsoup.Jsoup;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;

public class KieControllerSwaggerIntegrationTest
extends KieControllerManagementBaseTest {
    Client httpClient = ClientBuilder.newClient();

    @Test
    public void testSwaggerDocs() throws Exception {
        String html = this.invokeGet(this.getContextRoot() + "docs/");
        Assertions.assertThat((String)Jsoup.parse((String)html).title()).isIn(new Object[]{"Controller Documentation", "Business Central Documentation"});
    }

    @Test
    public void testSwaggerJson() throws Exception {
        String responseStr = this.invokeGet(this.getContextRoot() + "rest/swagger.json");
        ObjectMapper om = new ObjectMapper();
        HashMap hm = (HashMap)om.readValue(responseStr, HashMap.class);
        Assert.assertEquals((Object)"2.0", hm.get("swagger"));
    }

    protected String getContextRoot() {
        String url = TestConfig.getControllerHttpUrl();
        int pos = url.length();
        for (int i = 0; i < 2; ++i) {
            pos = url.lastIndexOf(47, pos - 1);
        }
        return url.substring(0, pos + 1);
    }

    protected String invokeGet(String docsUri) {
        WebTarget clientRequest = this.httpClient.target(docsUri);
        Response response = clientRequest.request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        return (String)response.readEntity(String.class);
    }
}

