/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.server.controller.client.event.EventHandler;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;

public class KieControllerCrashIntegrationTest
extends KieControllerManagementBaseTest {
    private CountDownLatch serverUp;
    private CountDownLatch serverDown;

    protected KieServicesClient createDefaultClient() {
        return null;
    }

    @Override
    @Before
    public void createControllerClient() {
        EventHandler eventHandler = new EventHandler(){

            public void onServerInstanceConnected(ServerInstanceConnected serverInstanceConnected) {
                KieControllerCrashIntegrationTest.this.serverUp.countDown();
            }

            public void onServerInstanceDeleted(ServerInstanceDeleted serverInstanceDeleted) {
            }

            public void onServerInstanceDisconnected(ServerInstanceDisconnected serverInstanceDisconnected) {
                KieControllerCrashIntegrationTest.this.serverDown.countDown();
            }

            public void onServerTemplateDeleted(ServerTemplateDeleted serverTemplateDeleted) {
            }

            public void onServerTemplateUpdated(ServerTemplateUpdated serverTemplateUpdated) {
            }

            public void onServerInstanceUpdated(ServerInstanceUpdated serverInstanceUpdated) {
            }

            public void onContainerSpecUpdated(ContainerSpecUpdated containerSpecUpdated) {
            }
        };
        this.controllerClient = TestConfig.isLocalServer() ? KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), (String)null, (String)null, (EventHandler)eventHandler) : KieServerControllerClientFactory.newWebSocketClient((String)TestConfig.getControllerWebSocketManagementUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword(), (EventHandler)eventHandler);
    }

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.serverUp = new CountDownLatch(1);
        this.serverDown = new CountDownLatch(1);
    }

    @After
    public void cleanupEmbeddedKieServer() {
    }

    @Test
    public void testCrashAfterRegistered() throws Exception {
        String SERVER_TEMPLATE_ID = "template-id";
        String SERVER_NAME = "server-name";
        KieServerEnvironment.setServerId((String)"template-id");
        ServerTemplate serverTemplate = new ServerTemplate("template-id", "server-name");
        this.controllerClient.saveServerTemplate(serverTemplate);
        ServerTemplateList instanceList = this.controllerClient.listServerTemplates();
        Assert.assertEquals((long)1L, (long)instanceList.getServerTemplates().length);
        KieServerInfo kieServerInfo = new KieServerInfo("template-id", "1.0.0");
        kieServerInfo.setLocation("http://127.0.0.1:20000");
        kieServerInfo.setMode(KieServerMode.PRODUCTION);
        kieServerInfo.setName("server-name");
        KieServerRegistryImpl registry = new KieServerRegistryImpl();
        KieServerStateRepository dummyKieServerStateRepository = new KieServerStateRepository(){

            public void store(String serverId, KieServerState kieServerState) {
            }

            public KieServerState load(String serverId) {
                KieServerState kieServerState = new KieServerState();
                kieServerState.setControllers(Collections.singleton(TestConfig.getControllerHttpUrl()));
                kieServerState.setConfiguration(new KieServerConfig());
                if (TestConfig.isLocalServer()) {
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.user", "", null));
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.pwd", "", null));
                } else {
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.user", TestConfig.getUsername(), null));
                    kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.controller.pwd", TestConfig.getPassword(), null));
                }
                return kieServerState;
            }
        };
        registry.registerStateRepository(dummyKieServerStateRepository);
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl((KieServerRegistry)registry);
        controller.connect(kieServerInfo);
        this.serverUp.await(5L, TimeUnit.SECONDS);
        ServerInstanceKeyList list = this.controllerClient.getServerInstances(instanceList.getServerTemplates()[0].getId());
        if (list.getServerInstanceKeys().length == 0) {
            this.serverUp = new CountDownLatch(1);
            this.serverDown = new CountDownLatch(1);
            controller.connect(kieServerInfo);
            this.serverUp.await(5L, TimeUnit.SECONDS);
            list = this.controllerClient.getServerInstances(instanceList.getServerTemplates()[0].getId());
        }
        Assert.assertNotNull((Object)list.getServerInstanceKeys());
        Assert.assertEquals((long)1L, (long)list.getServerInstanceKeys().length);
        this.serverDown.await(5L, TimeUnit.SECONDS);
        list = this.controllerClient.getServerInstances(instanceList.getServerTemplates()[0].getId());
        Assert.assertNotNull((Object)list.getServerInstanceKeys());
        Assert.assertEquals((long)0L, (long)list.getServerInstanceKeys().length);
    }
}

