/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.client.exception.KieServerControllerClientException;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.kie.server.integrationtests.controller.KieControllerManagementBaseTest;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.KieServerSynchronization;

public abstract class KieControllerRuntimeManagementIntegrationTest<T extends KieServerControllerClientException>
extends KieControllerManagementBaseTest {
    private KieServerInfo kieServerInfo;

    @BeforeClass
    public static void initialize() throws Exception {
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/stateless-session-kjar");
    }

    protected abstract void assertNotFoundException(T var1);

    protected abstract void assertBadRequestException(T var1);

    @Before
    public void getKieServerInfo() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
        ServiceResponse reply = this.client.getServerInfo();
        KieServerAssert.assertSuccess((ServiceResponse)reply);
        this.kieServerInfo = (KieServerInfo)reply.getResult();
    }

    @Test
    public void testGetContainersByInstance() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        this.createContainerSpec(serverTemplate, RELEASE_ID, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)RELEASE_ID);
        ServerInstanceKeyList serverInstances = this.controllerClient.getServerInstances(serverTemplate.getId());
        ServerInstanceKey serverInstance = serverInstances.getServerInstanceKeys()[0];
        ContainerList containers = this.controllerClient.getContainers(serverInstance);
        this.assertContainerList(serverTemplate, serverInstance, containers);
    }

    @Test
    public void testGetContainersByTemplate() throws Exception {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ContainerSpec containerSpec = this.createContainerSpec(serverTemplate, RELEASE_ID, KieContainerStatus.STARTED);
        KieServerSynchronization.waitForContainerWithReleaseId((KieServicesClient)this.client, (ReleaseId)RELEASE_ID);
        ServerInstanceKeyList serverInstances = this.controllerClient.getServerInstances(serverTemplate.getId());
        ServerInstanceKey serverInstance = serverInstances.getServerInstanceKeys()[0];
        ContainerList containers = this.controllerClient.getContainers(serverTemplate, containerSpec);
        this.assertContainerList(serverTemplate, serverInstance, containers);
    }

    protected void assertContainerList(ServerTemplate serverTemplate, ServerInstanceKey serverInstance, ContainerList containers) {
        Assertions.assertThat((Object[])containers.getContainers()).hasSize(1);
        Container container = containers.getContainers()[0];
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(container.getContainerSpecId()).isEqualTo("kie-concurrent");
            softly.assertThat(container.getContainerName()).isEqualTo("containerName");
            softly.assertThat((Comparable)container.getResolvedReleasedId()).isEqualTo((Object)RELEASE_ID);
            softly.assertThat(container.getServerInstanceId()).isEqualTo(serverInstance.getServerInstanceId());
            softly.assertThat(container.getServerTemplateId()).isEqualTo(serverTemplate.getId());
            softly.assertThat((Comparable)container.getStatus()).isEqualTo((Object)KieContainerStatus.STARTED);
        });
    }

    @Test
    public void testGetContainersFromNotExistingServerInstance() {
        ServerTemplate serverTemplate = this.createServerTemplate();
        ServerInstanceKey serverInstance = new ServerInstanceKey(serverTemplate.getId(), "not-existing", "not-existing", "not-existing");
        try {
            this.controllerClient.getContainers(serverInstance);
            Assertions.fail((String)"Should throw exception about the server instance not existing.");
        }
        catch (KieServerControllerClientException e) {
            this.assertNotFoundException(e);
            Assertions.assertThat((String)e.getMessage()).endsWith((CharSequence)("Server template with id " + serverTemplate.getId() + " has no instance with id not-existing"));
        }
    }

    protected ServerTemplate createServerTemplate() {
        return this.createServerTemplate(this.kieServerInfo.getServerId(), this.kieServerInfo.getName(), this.kieServerInfo.getLocation());
    }
}

