/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.CustomExtensionClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.filter.Authenticator;

public class CustomExtensionClientRest
implements CustomExtensionClient {
    private final KieServicesConfiguration config;
    private final Marshaller marshaller;
    private final Client httpClient;

    public CustomExtensionClientRest(KieServicesConfiguration configuration, ClassLoader classLoader) {
        this.config = configuration.clone();
        this.marshaller = MarshallerFactory.getMarshaller((Set)configuration.getExtraClasses(), (MarshallingFormat)configuration.getMarshallingFormat(), (ClassLoader)classLoader);
        this.httpClient = new ResteasyClientBuilder().establishConnectionTimeout(configuration.getTimeout(), TimeUnit.MILLISECONDS).socketTimeout(configuration.getTimeout(), TimeUnit.MILLISECONDS).register((Object)new Authenticator(configuration.getUserName(), configuration.getPassword())).build();
    }

    @Override
    public ExecutionResults insertFireReturn(String containerId, String kieSession, List<Object> listOfFacts) {
        String requestBody = this.marshaller.marshall(listOfFacts);
        Entity entity = Entity.entity((Object)requestBody, (String)this.getMediaType(this.config.getMarshallingFormat()));
        String url = this.getCustomEndpointUrl(containerId, kieSession);
        Response response = this.httpClient.target(url).request(new String[]{this.getMediaType(this.config.getMarshallingFormat())}).header("X-KIE-ContentType", (Object)this.config.getMarshallingFormat()).post(entity);
        String marshalledResponse = (String)response.readEntity(String.class);
        ExecutionResults result = (ExecutionResults)this.marshaller.unmarshall(marshalledResponse, ExecutionResultImpl.class);
        return result;
    }

    private String getCustomEndpointUrl(String containerId, String kieSession) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.config.getServerUrl());
        sb.append("/containers/instances/");
        sb.append(containerId);
        sb.append("/ksession/");
        sb.append(kieSession);
        return sb.toString();
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    @Override
    public void close() {
        this.httpClient.close();
    }
}

