/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.extension.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.drools.RulesExecutionService;
import org.kie.server.services.impl.KieServerImpl;

public class CustomDroolsKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "custom-drools";
    private static final Boolean droolsDisabled = Boolean.parseBoolean(System.getProperty("org.drools.server.ext.disabled", "false"));
    private boolean initialized = false;
    private KieServerRegistry registry;
    private RulesExecutionService rulesExecutionService;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return droolsDisabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        KieServerExtension droolsExtension = registry.getServerExtension("Drools");
        if (droolsExtension == null) {
            this.initialized = false;
            return;
        }
        List droolsServices = droolsExtension.getServices();
        for (Object service : droolsServices) {
            if (!RulesExecutionService.class.isAssignableFrom(service.getClass())) continue;
            this.rulesExecutionService = (RulesExecutionService)service;
        }
        this.registry = registry;
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        if (!this.initialized) {
            return appComponentsList;
        }
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        Object[] services = new Object[]{this.rulesExecutionService, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.rulesExecutionService.getClass())) {
            return (T)this.rulesExecutionService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "Custom Drools capability";
    }

    public List<Object> getServices() {
        ArrayList<Object> services = new ArrayList<Object>();
        services.add(this.rulesExecutionService);
        return services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 10;
    }

    public String toString() {
        return "custom-drools KIE Server extension";
    }
}

