/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.pmml;

import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.pmml.PMMLApplyModelBaseTest;

public class ApplyTreeModelIntegrationTest
extends PMMLApplyModelBaseTest {
    private static final String CORRELATION_ID = "123";
    private static final String MODEL_NAME = "SimpleClassificationTreeModel";
    private static final String FILE_NAME = "SimpleClassificationTree.pmml";
    private static final String TARGET_FIELD = "result";
    private static final Object EXPECTED_RESULT = "classA";
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 30000000L;
    private static final String MODEL_BASE = "tree";
    private static final String CONTAINER_ID_COMPILED = "tree-compiled";
    private static final String ARTIFACT_ID_COMPILED = "pmml-trusty-tree-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/pmml-trusty-tree-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "tree-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "pmml-trusty-tree-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/pmml-trusty-tree-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        ApplyTreeModelIntegrationTest.setup(RESOURCE_COMPILED, 30000000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        ApplyTreeModelIntegrationTest.setup(RESOURCE_NOT_COMPILED, 30000000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyPmmlTreeModelCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyPmmlTreeModelNotCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_NOT_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
        INPUT_DATA.put("input1", 5.0);
        INPUT_DATA.put("input2", 0.0);
        INPUT_DATA.put("input3", 0.0);
    }
}

