/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.scenariosimulation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.scenariosimulation.ScenarioSimulationFailure;
import org.kie.server.api.model.scenariosimulation.ScenarioSimulationResult;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ScenarioSimulationServicesClient;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.basetests.RestJmsSharedBaseIntegrationTest;

public class ScenarioSimulationIntegrationTest
extends RestJmsSharedBaseIntegrationTest {
    private static final ReleaseId kjar1 = new ReleaseId("org.kie.server.testing", "input-data-string", "1.0.0.Final");
    private static final String CONTAINER_1_ID = "input-data-string";
    private static final String DMN_SCESIM_SUCCESS_PATH = "/input-data-string-success.scesim";
    private static final String DMN_SCESIM_FAIL_PATH = "/input-data-string-fail.scesim";
    private static final String RULE_SCESIM_SUCCESS_PATH = "/rule-success.scesim";
    private static final String RULE_SCESIM_FAIL_PATH = "/rule-fail.scesim";
    private ScenarioSimulationServicesClient scenarioSimulationServicesClient;

    protected void setupClients(KieServicesClient kieServicesClient) {
        this.scenarioSimulationServicesClient = (ScenarioSimulationServicesClient)kieServicesClient.getServicesClient(ScenarioSimulationServicesClient.class);
    }

    @BeforeClass
    public static void deployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)"/kjars-sources/input-data-string");
        kieContainer = KieServices.Factory.get().newKieContainer((org.kie.api.builder.ReleaseId)kjar1);
        ScenarioSimulationIntegrationTest.createContainer((String)CONTAINER_1_ID, (ReleaseId)kjar1);
    }

    @Test
    public void executeScenarioByPathTest() throws Exception {
        this.commonExecuteScenario((containerId, localPath) -> this.scenarioSimulationServicesClient.executeScenarioByPath(containerId, ScenarioSimulationIntegrationTest.convertToAbsolutePath(localPath)));
    }

    @Test
    public void executeScenarioTest() throws Exception {
        this.commonExecuteScenario((containerId, content) -> this.scenarioSimulationServicesClient.executeScenario(containerId, ScenarioSimulationIntegrationTest.loadResource(content)));
    }

    private void commonExecuteScenario(CheckedExceptionBiFunction<String, String, ServiceResponse<ScenarioSimulationResult>> methodToTest) throws Exception {
        ServiceResponse<ScenarioSimulationResult> dmnResponseSuccess = methodToTest.apply(CONTAINER_1_ID, DMN_SCESIM_SUCCESS_PATH);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)dmnResponseSuccess.getType());
        Assert.assertEquals((long)1L, (long)((ScenarioSimulationResult)dmnResponseSuccess.getResult()).getRunCount());
        Assert.assertEquals((Object)"Test Scenario successfully executed", (Object)dmnResponseSuccess.getMsg());
        ServiceResponse<ScenarioSimulationResult> dmnResponseFail = methodToTest.apply(CONTAINER_1_ID, DMN_SCESIM_FAIL_PATH);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)dmnResponseFail.getType());
        Assert.assertEquals((long)1L, (long)((ScenarioSimulationResult)dmnResponseFail.getResult()).getRunCount());
        Assert.assertEquals((Object)"Test Scenario execution failed", (Object)dmnResponseFail.getMsg());
        Assert.assertFalse((boolean)((ScenarioSimulationResult)dmnResponseFail.getResult()).getFailures().isEmpty());
        Assert.assertEquals((Object)"#1 KO scenario: Failed in \"Greeting Message\": The expected value is \"\"Hello John\"\" but the actual one is \"\"Hello John 1\"\"", (Object)((ScenarioSimulationFailure)((ScenarioSimulationResult)dmnResponseFail.getResult()).getFailures().get(0)).getErrorMessage());
        ServiceResponse<ScenarioSimulationResult> ruleResponseSuccess = methodToTest.apply(CONTAINER_1_ID, RULE_SCESIM_SUCCESS_PATH);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)ruleResponseSuccess.getType());
        Assert.assertEquals((long)1L, (long)((ScenarioSimulationResult)ruleResponseSuccess.getResult()).getRunCount());
        Assert.assertEquals((Object)"Test Scenario successfully executed", (Object)ruleResponseSuccess.getMsg());
        ServiceResponse<ScenarioSimulationResult> ruleResponseFail = methodToTest.apply(CONTAINER_1_ID, RULE_SCESIM_FAIL_PATH);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)ruleResponseFail.getType());
        Assert.assertEquals((long)1L, (long)((ScenarioSimulationResult)ruleResponseFail.getResult()).getRunCount());
        Assert.assertEquals((Object)"Test Scenario execution failed", (Object)ruleResponseFail.getMsg());
        Assert.assertFalse((boolean)((ScenarioSimulationResult)ruleResponseFail.getResult()).getFailures().isEmpty());
        Assert.assertEquals((Object)"#1 KO scenario: Failed in \"String\": The expected value is \"John\" but the actual one is \"John 1\"", (Object)((ScenarioSimulationFailure)((ScenarioSimulationResult)ruleResponseFail.getResult()).getFailures().get(0)).getErrorMessage());
    }

    private static String loadResource(String path) throws IOException {
        return Files.lines(ScenarioSimulationIntegrationTest.loadPathFromResource(path), StandardCharsets.UTF_8).collect(Collectors.joining("\n"));
    }

    private static String convertToAbsolutePath(String path) {
        return ScenarioSimulationIntegrationTest.loadPathFromResource(path).toFile().getAbsolutePath();
    }

    private static Path loadPathFromResource(String path) {
        return Paths.get(ScenarioSimulationIntegrationTest.class.getResource(path).getFile(), new String[0]);
    }

    @FunctionalInterface
    private static interface CheckedExceptionBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }
}

