/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.resource;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.kie.server.services.impl.marshal.MarshallerHelper;

@Path(value="server")
public class KieServerRestImpl {
    private KieServerImpl server;
    private MarshallerHelper marshallerHelper;

    public KieServerRestImpl() {
        this.server = KieServerLocator.getInstance();
        this.marshallerHelper = new MarshallerHelper(this.server.getServerRegistry());
    }

    public KieServerRestImpl(KieServerImpl server) {
        this.server = server;
        this.marshallerHelper = new MarshallerHelper(server.getServerRegistry());
    }

    public KieServerImpl getServer() {
        return this.server;
    }

    public void setServer(KieServerImpl server) {
        this.server = server;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getInfo(@Context HttpHeaders headers) {
        return RestUtils.createCorrectVariant(this.server.getInfo(), headers);
    }

    @GET
    @Path(value="containers")
    @Produces(value={"application/xml", "application/json"})
    public Response listContainers(@Context HttpHeaders headers) {
        return RestUtils.createCorrectVariant(this.server.listContainers(), headers);
    }

    @PUT
    @Path(value="containers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createContainer(@Context HttpHeaders headers, @PathParam(value="id") String id, String containerPayload) {
        String contentType = RestUtils.getContentType(headers);
        KieContainerResource container = (KieContainerResource)this.marshallerHelper.unmarshal(containerPayload, contentType, KieContainerResource.class);
        ServiceResponse response = this.server.createContainer(id, container);
        if (response.getType() == ServiceResponse.ResponseType.SUCCESS) {
            return RestUtils.createCorrectVariant(response, headers, Response.Status.CREATED);
        }
        return RestUtils.createCorrectVariant(response, headers, Response.Status.BAD_REQUEST);
    }

    @GET
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response getContainerInfo(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        return RestUtils.createCorrectVariant(this.server.getContainerInfo(id), headers);
    }

    @DELETE
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response disposeContainer(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        return RestUtils.createCorrectVariant(this.server.disposeContainer(id), headers);
    }

    @GET
    @Path(value="containers/{id}/scanner")
    @Produces(value={"application/xml", "application/json"})
    public Response getScannerInfo(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        return RestUtils.createCorrectVariant(this.server.getScannerInfo(id), headers);
    }

    @POST
    @Path(value="containers/{id}/scanner")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateScanner(@Context HttpHeaders headers, @PathParam(value="id") String id, String resourcePayload) {
        String contentType = RestUtils.getContentType(headers);
        KieScannerResource resource = (KieScannerResource)this.marshallerHelper.unmarshal(resourcePayload, contentType, KieScannerResource.class);
        return RestUtils.createCorrectVariant(this.server.updateScanner(id, resource), headers);
    }

    @GET
    @Path(value="containers/{id}/release-id")
    @Produces(value={"application/xml", "application/json"})
    public Response getReleaseId(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        return RestUtils.createCorrectVariant(this.server.getContainerReleaseId(id), headers);
    }

    @POST
    @Path(value="containers/{id}/release-id")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateReleaseId(@Context HttpHeaders headers, @PathParam(value="id") String id, String releaseIdPayload) {
        String contentType = RestUtils.getContentType(headers);
        ReleaseId releaseId = (ReleaseId)this.marshallerHelper.unmarshal(releaseIdPayload, contentType, ReleaseId.class);
        return RestUtils.createCorrectVariant(this.server.updateContainerReleaseId(id, releaseId), headers);
    }
}

