/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.util;

import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.server.api.ConversationId;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.marshal.MarshallerHelper;

public class RestUtils {
    public static Variant defaultVariant = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build().get(0);
    private static MarshallerHelper marshallerHelper = new MarshallerHelper(null);

    public static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Header ... customHeaders) {
        return RestUtils.createCorrectVariant(responseObj, headers, null, customHeaders);
    }

    public static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status, Header ... customHeaders) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestUtils.getVariant(headers);
        String contentType = RestUtils.getContentType(headers);
        responseBuilder = status != null ? Response.status((Response.Status)status).entity((Object)marshallerHelper.marshal(contentType, responseObj)).variant(v) : Response.ok((Object)marshallerHelper.marshal(contentType, responseObj), (Variant)v);
        RestUtils.applyCustomHeaders(responseBuilder, customHeaders);
        return responseBuilder.build();
    }

    public static Response createCorrectVariant(MarshallerHelper marshallerHelper, String containerId, Object responseObj, HttpHeaders headers, Response.Status status, Header ... customHeaders) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestUtils.getVariant(headers);
        String contentType = RestUtils.getContentType(headers);
        String marshalledResponse = marshallerHelper.getRegistry().getContainer(containerId) == null ? marshallerHelper.marshal(contentType, responseObj) : marshallerHelper.marshal(containerId, contentType, responseObj);
        responseBuilder = status != null ? Response.status((Response.Status)status).entity((Object)marshalledResponse).variant(v) : Response.ok((Object)marshalledResponse, (Variant)v);
        RestUtils.applyCustomHeaders(responseBuilder, customHeaders);
        return responseBuilder.build();
    }

    public static Response createResponse(Object responseObj, Variant v, Response.Status status, Header ... customHeaders) {
        Response.ResponseBuilder responseBuilder = null;
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        RestUtils.applyCustomHeaders(responseBuilder, customHeaders);
        return responseBuilder.build();
    }

    public static Variant getVariant(HttpHeaders headers) {
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = defaultVariant;
        }
        return v;
    }

    public static String getClassType(HttpHeaders headers) {
        String classType = null;
        List header = headers.getRequestHeader("X-KIE-ClassType");
        if (header != null && !header.isEmpty()) {
            classType = (String)header.get(0);
        }
        return classType;
    }

    public static String getContentType(HttpHeaders headers) {
        Variant v = RestUtils.getVariant(headers);
        String contentType = v.getMediaType().getSubtype();
        List kieContentTypeHeader = headers.getRequestHeader("X-KIE-ContentType");
        if (kieContentTypeHeader != null && !kieContentTypeHeader.isEmpty()) {
            contentType = (String)kieContentTypeHeader.get(0);
        }
        return contentType;
    }

    public static Response notFound(String message, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse(message, v, Response.Status.NOT_FOUND, customHeaders);
    }

    public static Response internalServerError(String message, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse(message, v, Response.Status.INTERNAL_SERVER_ERROR, customHeaders);
    }

    public static Response alreadyExists(String message, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse(message, v, Response.Status.CONFLICT, customHeaders);
    }

    public static Response noContent(Variant v, Header ... customHeaders) {
        return RestUtils.createResponse("", v, Response.Status.NO_CONTENT, customHeaders);
    }

    protected static void applyCustomHeaders(Response.ResponseBuilder builder, Header ... customHeaders) {
        if (customHeaders != null && customHeaders.length > 0) {
            for (Header header : customHeaders) {
                if (header == null) continue;
                builder.header(header.getName(), (Object)header.getValue());
            }
        }
    }

    public static Header buildConversationIdHeader(String containerId, KieServerRegistry registry, HttpHeaders headers) {
        List conversationIdHeader = headers.getRequestHeader("X-KIE-ConversationId");
        if (conversationIdHeader != null && !conversationIdHeader.isEmpty()) {
            return new Header("X-KIE-ConversationId", (String)conversationIdHeader.get(0));
        }
        KieContainerInstanceImpl container = registry.getContainer(containerId);
        if (container != null) {
            ReleaseId releaseId = container.getResource().getResolvedReleaseId();
            if (releaseId == null) {
                releaseId = container.getResource().getReleaseId();
            }
            String conversationId = ConversationId.from((String)KieServerEnvironment.getServerId(), (String)containerId, (ReleaseId)releaseId).toString();
            return new Header("X-KIE-ConversationId", conversationId);
        }
        return null;
    }
}

