/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Severity;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.kie.server.services.impl.marshal.MarshallerHelper;

@Api(value="KIE Server :: Core")
@Path(value="server")
public class KieServerRestImpl {
    private KieServerImpl server;
    private MarshallerHelper marshallerHelper;

    public KieServerRestImpl() {
        this.server = KieServerLocator.getInstance();
        this.marshallerHelper = new MarshallerHelper(this.server.getServerRegistry());
    }

    public KieServerRestImpl(KieServerImpl server) {
        this.server = server;
        this.marshallerHelper = new MarshallerHelper(server.getServerRegistry());
    }

    public KieServerImpl getServer() {
        return this.server;
    }

    public void setServer(KieServerImpl server) {
        this.server = server;
    }

    @ApiOperation(value="Retrieves KIE Server information - id, name, location, capabilities, messages", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getInfo(@Context HttpHeaders headers) {
        return RestUtils.createCorrectVariant((Object)this.server.getInfo(), headers, new Header[0]);
    }

    @ApiOperation(value="Retrieves containers deployed to this server, optionally filtered by group, artifact, version or status", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="containers")
    @Produces(value={"application/xml", "application/json"})
    public Response listContainers(@Context HttpHeaders headers, @ApiParam(value="optional groupId to filter containers by", required=false) @QueryParam(value="groupId") String groupId, @ApiParam(value="optional artifactId to filter containers by", required=false) @QueryParam(value="artifactId") String artifactId, @ApiParam(value="optional version to filter containers by", required=false) @QueryParam(value="version") String version, @ApiParam(value="optional status to filter containers by", required=false) @QueryParam(value="status") String status) {
        ReleaseIdFilter releaseIdFilter = new ReleaseIdFilter.Builder().groupId(groupId).artifactId(artifactId).version(version).build();
        KieContainerStatusFilter statusFilter = KieContainerStatusFilter.parseFromNullableString((String)status);
        KieContainerResourceFilter containerFilter = new KieContainerResourceFilter(releaseIdFilter, statusFilter);
        return RestUtils.createCorrectVariant((Object)this.server.listContainers(containerFilter), headers, new Header[0]);
    }

    @ApiOperation(value="Creates (deploys) new KIE container to this server", response=ServiceResponse.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="container could not be created")})
    @PUT
    @Path(value="containers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createContainer(@Context HttpHeaders headers, @ApiParam(value="Container id to be assigned to deployed KIE Container", required=true) @PathParam(value="id") String id, @ApiParam(value="KIE Container resource to be deployed as KieContainerResource", required=true) String containerPayload) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        String contentType = RestUtils.getContentType(headers);
        KieContainerResource container = (KieContainerResource)this.marshallerHelper.unmarshal(containerPayload, contentType, KieContainerResource.class);
        ServiceResponse response = this.server.createContainer(id, container);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        if (response.getType() == KieServiceResponse.ResponseType.SUCCESS) {
            return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.CREATED, conversationIdHeader);
        }
        return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.BAD_REQUEST, new Header[0]);
    }

    @ApiOperation(value="Activates (previously deactivated) KIE container on this server", response=ServiceResponse.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="container could not be activated")})
    @PUT
    @Path(value="containers/{id}/status/activated")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response activateContainer(@Context HttpHeaders headers, @ApiParam(value="Container id of deployed KIE Container", required=true) @PathParam(value="id") String id) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        ServiceResponse response = this.server.activateContainer(id);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        if (response.getType() == KieServiceResponse.ResponseType.SUCCESS) {
            return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.CREATED, conversationIdHeader);
        }
        return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.BAD_REQUEST, new Header[0]);
    }

    @ApiOperation(value="Deactivates (previously started) KIE container on this server", response=ServiceResponse.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="container could not be deactivated")})
    @PUT
    @Path(value="containers/{id}/status/deactivated")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response deactivateContainer(@Context HttpHeaders headers, @ApiParam(value="Container id of deployed KIE Container", required=true) @PathParam(value="id") String id) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        ServiceResponse response = this.server.deactivateContainer(id);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        if (response.getType() == KieServiceResponse.ResponseType.SUCCESS) {
            return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.CREATED, conversationIdHeader);
        }
        return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.BAD_REQUEST, new Header[0]);
    }

    @ApiOperation(value="Retrieves container with given id", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response getContainerInfo(@Context HttpHeaders headers, @ApiParam(value="Container id to be retrieved", required=true) @PathParam(value="id") String id) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.getContainerInfo(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Disposes (undeploys) container with given id", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @DELETE
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response disposeContainer(@Context HttpHeaders headers, @ApiParam(value="Container id to be disposed (undeployed)", required=true) @PathParam(value="id") String id) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.disposeContainer(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Retrieves scanner information for given container", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="containers/{id}/scanner")
    @Produces(value={"application/xml", "application/json"})
    public Response getScannerInfo(@Context HttpHeaders headers, @ApiParam(value="Container id for scanner to be loaded", required=true) @PathParam(value="id") String id) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.getScannerInfo(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Updates scanner for given container", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="containers/{id}/scanner")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateScanner(@Context HttpHeaders headers, @ApiParam(value="Container id for scanner to be updated", required=true) @PathParam(value="id") String id, @ApiParam(value="Scanner information given as KieScannerResource type", required=true) String resourcePayload) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        String contentType = RestUtils.getContentType(headers);
        KieScannerResource resource = (KieScannerResource)this.marshallerHelper.unmarshal(resourcePayload, contentType, KieScannerResource.class);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.updateScanner(id, resource), headers, conversationIdHeader);
    }

    @ApiOperation(value="Retrieves release id of the KIE container with given id", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="containers/{id}/release-id")
    @Produces(value={"application/xml", "application/json"})
    public Response getReleaseId(@Context HttpHeaders headers, @ApiParam(value="Container id that release id should be loaded from", required=true) @PathParam(value="id") String id) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.getContainerReleaseId(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Updates release id of the KIE container with given id to provided release id", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="containers/{id}/release-id")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateReleaseId(@Context HttpHeaders headers, @ApiParam(value="Container id that release id should be upgraded", required=true) @PathParam(value="id") String id, @ApiParam(value="Release Id to be upgraded to as ReleaseId type", required=true) String releaseIdPayload) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        String contentType = RestUtils.getContentType(headers);
        ReleaseId releaseId = (ReleaseId)this.marshallerHelper.unmarshal(releaseIdPayload, contentType, ReleaseId.class);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.updateContainerReleaseId(id, releaseId), headers, conversationIdHeader);
    }

    @ApiOperation(value="Retrieves server state - configuration that the server is currently running with", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="state")
    @Produces(value={"application/xml", "application/json"})
    public Response getServerState(@Context HttpHeaders headers) {
        return RestUtils.createCorrectVariant((Object)this.server.getServerState(), headers, new Header[0]);
    }

    @ApiOperation(value="Readiness check for KIE Server that indicates that server is fully booted and ready to accept requests", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=503, message="Service not yet available")})
    @GET
    @Path(value="readycheck")
    @Produces(value={"text/plain"})
    public Response readycheck(@Context HttpHeaders headers) {
        if (this.server.isKieServerReady()) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return RestUtils.serviceUnavailable(new Header[0]);
    }

    @ApiOperation(value="Liveness check for KIE Server that validates both kie server and all extensions, optionally produces report", response=Message.class, code=200, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=503, message="If any of the checks failed")})
    @GET
    @Path(value="healthcheck")
    @Produces(value={"application/xml", "application/json"})
    public Response healthcheck(@Context HttpHeaders headers, @ApiParam(value="optional report flag to return detailed report of the check, defaults to false", required=false) @QueryParam(value="report") @DefaultValue(value="false") boolean report) {
        List healthMessages = this.server.healthCheck(report);
        boolean anyfailures = healthMessages.stream().anyMatch(msg -> msg.getSeverity().equals((Object)Severity.ERROR));
        if (anyfailures) {
            if (report) {
                return RestUtils.createCorrectVariant((Object)healthMessages, headers, Response.Status.SERVICE_UNAVAILABLE, new Header[0]);
            }
            return RestUtils.serviceUnavailable(new Header[0]);
        }
        if (report) {
            return RestUtils.createCorrectVariant((Object)healthMessages, headers, Response.Status.OK, new Header[0]);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

