/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.marker;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.remote.rest.common.marker.KieServerEndpoint;
import org.kie.server.remote.rest.common.marker.KieServerEndpointRequestFilter;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerEndpointRequestFilterTest {
    @Mock
    private ResourceInfo resourceInfo;
    @InjectMocks
    private KieServerEndpointRequestFilter filter = new KieServerEndpointRequestFilter();

    @Test
    public void testGetAlwaysPass() throws Exception {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)this.resourceInfo.getResourceMethod()).thenReturn((Object)TestSimpleOperations.class.getMethod("test1", new Class[0]));
        Mockito.when((Object)this.resourceInfo.getResourceClass()).thenReturn(TestSimpleOperations.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        this.filter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.times((int)0))).abortWith((Response)Matchers.anyObject());
    }

    @Test
    public void testOtherOperationNoPass() throws Exception {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)this.resourceInfo.getResourceMethod()).thenReturn((Object)TestSimpleOperations.class.getMethod("test1", new Class[0]));
        Mockito.when((Object)this.resourceInfo.getResourceClass()).thenReturn(TestSimpleOperations.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        this.filter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.times((int)1))).abortWith((Response)Matchers.anyObject());
    }

    @Test
    public void testOtherNoPassAnnotationPass() throws Exception {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)this.resourceInfo.getResourceMethod()).thenReturn((Object)TestAnnotationOperations.class.getMethod("test1", new Class[0]));
        Mockito.when((Object)this.resourceInfo.getResourceClass()).thenReturn(TestAnnotationOperations.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        this.filter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.times((int)1))).abortWith((Response)Matchers.anyObject());
    }

    @Test
    public void testOtherAlwaysPassAnnotationPass() throws Exception {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)this.resourceInfo.getResourceMethod()).thenReturn((Object)TestAnnotationOperations.class.getMethod("test2", new Class[0]));
        Mockito.when((Object)this.resourceInfo.getResourceClass()).thenReturn(TestAnnotationOperations.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        this.filter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.times((int)0))).abortWith((Response)Matchers.anyObject());
    }

    @Test
    public void testOtherOverrideBadPassAnnotationPass() throws Exception {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)this.resourceInfo.getResourceMethod()).thenReturn((Object)TestTypeAnnotationOperations.class.getMethod("test1", new Class[0]));
        Mockito.when((Object)this.resourceInfo.getResourceClass()).thenReturn(TestTypeAnnotationOperations.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        this.filter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.times((int)1))).abortWith((Response)Matchers.anyObject());
    }

    @Test
    public void testOtherTypePassAnnotationPass() throws Exception {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)this.resourceInfo.getResourceMethod()).thenReturn((Object)TestAnnotationOperations.class.getMethod("test2", new Class[0]));
        Mockito.when((Object)this.resourceInfo.getResourceClass()).thenReturn(TestAnnotationOperations.class);
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        this.filter.filter(requestContext);
        ((ContainerRequestContext)Mockito.verify((Object)requestContext, (VerificationMode)Mockito.times((int)0))).abortWith((Response)Matchers.anyObject());
    }

    @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.HISTORY})
    static class TestTypeAnnotationOperations {
        TestTypeAnnotationOperations() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT})
        public void test1() {
        }

        public void test2() {
        }
    }

    static class TestAnnotationOperations {
        TestAnnotationOperations() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT})
        public void test1() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.ALWAYS})
        public void test2() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.HISTORY})
        public void test3() {
        }
    }

    static class TestSimpleOperations {
        TestSimpleOperations() {
        }

        public void test1() {
        }

        public void test2() {
        }
    }
}

