/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.util;

import java.util.ArrayList;
import javax.ws.rs.core.HttpHeaders;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.mockito.Mockito;

public class RestUtilsTest {
    private static final String CONTAINER_ID = "my-container";
    private KieServerRegistry registry;
    private HttpHeaders headers;

    @Before
    public void setup() {
        this.registry = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        this.headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
    }

    @Test
    public void buildConversationIdHeaderWithPresentHeader() {
        String conversationId = "my-conversation-id";
        ArrayList<String> requestHeaders = new ArrayList<String>();
        requestHeaders.add(conversationId);
        Mockito.when((Object)this.headers.getRequestHeader("X-KIE-ConversationId")).thenReturn(requestHeaders);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)CONTAINER_ID, (KieServerRegistry)this.registry, (HttpHeaders)this.headers);
        Assert.assertEquals((Object)"X-KIE-ConversationId", (Object)conversationIdHeader.getName());
        Assert.assertEquals((Object)conversationId, (Object)conversationIdHeader.getValue());
    }

    @Test
    public void buildConversationIdHeaderWithoutContainer() {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)CONTAINER_ID, (KieServerRegistry)this.registry, (HttpHeaders)this.headers);
        Assert.assertNull((Object)conversationIdHeader);
    }

    @Test
    public void buildConversationIdHeaderNullContainer() {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(null, (KieServerRegistry)this.registry, (HttpHeaders)this.headers);
        Assert.assertNull((Object)conversationIdHeader);
    }

    @Test
    public void buildConversationIdHeaderRunningContainer() {
        String kieServerId = "KieServerId";
        KieServerEnvironment.setServerId((String)kieServerId);
        String groupId = "org.kie";
        String artifactId = "testArtifact";
        String version = "1.0";
        ReleaseId releaseId = new ReleaseId(groupId, artifactId, version);
        KieContainerInstanceImpl containerInstanceImpl = new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED);
        containerInstanceImpl.getResource().setReleaseId(releaseId);
        Mockito.when((Object)this.registry.getContainer(CONTAINER_ID)).thenReturn((Object)containerInstanceImpl);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)CONTAINER_ID, (KieServerRegistry)this.registry, (HttpHeaders)this.headers);
        Assert.assertEquals((Object)"X-KIE-ConversationId", (Object)conversationIdHeader.getName());
        Assert.assertNotNull((Object)conversationIdHeader.getValue());
        Assert.assertTrue((boolean)conversationIdHeader.getValue().contains(groupId));
        Assert.assertTrue((boolean)conversationIdHeader.getValue().contains(artifactId));
        Assert.assertTrue((boolean)conversationIdHeader.getValue().contains(version));
        Assert.assertTrue((boolean)conversationIdHeader.getValue().contains(CONTAINER_ID));
        Assert.assertTrue((boolean)conversationIdHeader.getValue().contains(kieServerId));
    }

    @Test
    public void buildConversationIdHeaderCreatingContainer() {
        String kieServerId = "KieServerId";
        KieServerEnvironment.setServerId((String)kieServerId);
        KieContainerInstanceImpl containerInstanceImpl = new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.CREATING);
        Mockito.when((Object)this.registry.getContainer(CONTAINER_ID)).thenReturn((Object)containerInstanceImpl);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)CONTAINER_ID, (KieServerRegistry)this.registry, (HttpHeaders)this.headers);
        Assert.assertNull((Object)conversationIdHeader);
    }
}

