/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.marker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.kie.server.remote.rest.common.marker.KieServerEndpoint;

@Provider
public class KieServerEndpointRequestFilter
implements ContainerRequestFilter {
    private final List<KieServerEndpoint.EndpointType> valid = Arrays.asList(KieServerEndpoint.EndpointType.ALWAYS, KieServerEndpoint.EndpointType.HISTORY);
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        KieServerEndpoint endpoint = null;
        if (this.resourceInfo.getResourceMethod().isAnnotationPresent(KieServerEndpoint.class)) {
            endpoint = this.resourceInfo.getResourceMethod().getAnnotation(KieServerEndpoint.class);
        } else if (this.resourceInfo.getResourceClass().isAnnotationPresent(KieServerEndpoint.class)) {
            endpoint = this.resourceInfo.getResourceClass().getAnnotation(KieServerEndpoint.class);
        }
        if ("GET".equals(requestContext.getMethod())) {
            return;
        }
        if (endpoint == null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Endpoint disabled").build());
            return;
        }
        ArrayList<KieServerEndpoint.EndpointType> current = new ArrayList<KieServerEndpoint.EndpointType>(Arrays.asList(endpoint.categories()));
        current.retainAll(this.valid);
        if (current.isEmpty()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Endpoint disabled").build());
        }
    }
}

