/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.dmn;

import java.text.MessageFormat;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.dmn.ModelEvaluatorServiceBase;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/containers/{id}/dmn")
public class ModelEvaluatorResource {
    public static final Logger LOG = LoggerFactory.getLogger(ModelEvaluatorResource.class);
    private ModelEvaluatorServiceBase modelEvaluatorService;
    private MarshallerHelper marshallerHelper;

    public ModelEvaluatorResource() {
    }

    public ModelEvaluatorResource(ModelEvaluatorServiceBase modelEvaluatorService) {
        this.modelEvaluatorService = modelEvaluatorService;
        this.marshallerHelper = new MarshallerHelper(modelEvaluatorService.getKieServerRegistry());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getModels(@Context HttpHeaders headers, @PathParam(value="id") String containerId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.modelEvaluatorService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.modelEvaluatorService.getModels(containerId);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            LOG.error("Unexpected error retrieving models. Message: '{}'", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("ERROR", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response evaluateAllDecisions(@Context HttpHeaders headers, @PathParam(value="id") String containerId, String payload) {
        LOG.debug("About to evaluateAllDecisions on container {}", (Object)containerId);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.modelEvaluatorService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            String contentType = RestUtils.getContentType((HttpHeaders)headers);
            LOG.debug("Payload received: {}", (Object)payload);
            ServiceResponse result = this.modelEvaluatorService.evaluateAllDecisions(containerId, payload, contentType);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            LOG.error("Unexpected error retrieving models. Message: '{}'", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("ERROR", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

