/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.search;

import java.text.MessageFormat;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dashbuilder.dataset.exception.DataSetLookupException;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.common.rest.HttpStatusCodeException;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.remote.rest.jbpm.search.TaskSearchResource;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.search.ProcessInstanceSearchServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/processes/instances/filtered-data")
public class ProcessInstanceSearchResource {
    private static final Logger logger = LoggerFactory.getLogger(TaskSearchResource.class);
    private ProcessInstanceSearchServiceBase processInstanceQueryServiceBase;
    private KieServerRegistry context;

    public ProcessInstanceSearchResource() {
    }

    public ProcessInstanceSearchResource(ProcessInstanceSearchServiceBase processInstanceQueryServiceBase, KieServerRegistry context) {
        this.processInstanceQueryServiceBase = processInstanceQueryServiceBase;
        this.context = context;
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesWithFilters(@Context HttpHeaders headers, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, String payload) {
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ProcessInstanceList result = this.processInstanceQueryServiceBase.getProcessInstancesWithFilters(page, pageSize, payload, type);
            logger.debug("Returning result of process instance search: {}", (Object)result);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            if (HttpStatusCodeException.BAD_REQUEST.contains(root.getClass()) || e instanceof DataSetLookupException) {
                logger.error("{}", (Object)MessageFormat.format("The request could not be understood by the server due to malformed syntax: {0}", root.getMessage()), (Object)e);
                return RestUtils.badRequest((String)MessageFormat.format("The request could not be understood by the server due to malformed syntax: {0}", root.getMessage()), (Variant)RestUtils.getVariant((HttpHeaders)headers), (Header[])new Header[]{conversationIdHeader});
            }
            logger.error("{}", (Object)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)RestUtils.getVariant((HttpHeaders)headers), (Header[])new Header[]{conversationIdHeader});
        }
    }
}

