/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.search;

import java.util.Collections;
import java.util.HashSet;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.definition.TaskQueryFilterSpec;
import org.kie.server.api.model.instance.TaskInstanceList;
import org.kie.server.remote.rest.jbpm.search.TaskSearchResource;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.search.TaskSearchServiceBase;
import org.mockito.Mockito;
import org.skyscreamer.jsonassert.JSONAssert;
import org.xmlunit.matchers.CompareMatcher;

public class TaskSearchResourceTest {
    @Test
    public void testGetHumanTasksWithFiltersXML() throws Exception {
        TaskSearchServiceBase tqsbMock = (TaskSearchServiceBase)Mockito.mock(TaskSearchServiceBase.class);
        KieServerRegistry contextMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        HashSet<Class<TaskQueryFilterSpec>> extraClasses = new HashSet<Class<TaskQueryFilterSpec>>();
        extraClasses.add(TaskQueryFilterSpec.class);
        Mockito.when((Object)contextMock.getExtraClasses()).thenReturn(extraClasses);
        Mockito.when((Object)tqsbMock.getHumanTasksWithFilters((Integer)Mockito.any(), (Integer)Mockito.any(), (String)Mockito.any(), (String)Mockito.eq((Object)"JAXB"))).thenReturn((Object)TaskSearchResourceTest.getTaskInstanceList());
        TaskSearchResource tqr = new TaskSearchResource(tqsbMock, contextMock);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.put((Object)"X-KIE-ContentType", Collections.singletonList("JAXB"));
        headers.put((Object)"Content-Type", Collections.singletonList("application/xml"));
        headers.put((Object)"Accept", Collections.singletonList("application/json"));
        ResteasyHttpHeaders httpHeaders = new ResteasyHttpHeaders((MultivaluedMap)headers);
        Response response = tqr.getHumanTasksWithFilters((HttpHeaders)httpHeaders, Integer.valueOf(0), Integer.valueOf(10), TaskSearchResourceTest.getPayload());
        String responseEntity = (String)response.getEntity();
        String expectedResponseEntity = "<task-instance-list/>";
        Assert.assertThat((Object)responseEntity, (Matcher)CompareMatcher.isIdenticalTo((Object)expectedResponseEntity).ignoreWhitespace());
    }

    @Test
    public void testGetHumanTasksWithFilterJSON() throws Exception {
        TaskSearchServiceBase tqsbMock = (TaskSearchServiceBase)Mockito.mock(TaskSearchServiceBase.class);
        KieServerRegistry contextMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        HashSet<Class<TaskQueryFilterSpec>> extraClasses = new HashSet<Class<TaskQueryFilterSpec>>();
        extraClasses.add(TaskQueryFilterSpec.class);
        Mockito.when((Object)contextMock.getExtraClasses()).thenReturn(extraClasses);
        Mockito.when((Object)tqsbMock.getHumanTasksWithFilters((Integer)Mockito.any(), (Integer)Mockito.any(), (String)Mockito.any(), (String)Mockito.eq((Object)"JSON"))).thenReturn((Object)TaskSearchResourceTest.getTaskInstanceList());
        TaskSearchResource tqr = new TaskSearchResource(tqsbMock, contextMock);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.put((Object)"X-KIE-ContentType", Collections.singletonList("JSON"));
        headers.put((Object)"Content-Type", Collections.singletonList("application/json"));
        headers.put((Object)"Accept", Collections.singletonList("application/json"));
        ResteasyHttpHeaders httpHeaders = new ResteasyHttpHeaders((MultivaluedMap)headers);
        Response response = tqr.getHumanTasksWithFilters((HttpHeaders)httpHeaders, Integer.valueOf(0), Integer.valueOf(10), TaskSearchResourceTest.getPayload());
        String responseEntity = (String)response.getEntity();
        String expectedResponseEntity = "{" + "\"task-instance\" : null" + "}";
        JSONAssert.assertEquals((String)expectedResponseEntity, (String)responseEntity, (boolean)false);
    }

    private static String getPayload() {
        StringBuilder payloadBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        payloadBuilder.append("<task-query-filter-spec>");
        payloadBuilder.append("<order-asc>false</order-asc>");
        payloadBuilder.append("<query-params>");
        payloadBuilder.append("<cond-column>DEPLOYMENTID</cond-column>");
        payloadBuilder.append("<cond-operator>EQUALS_TO</cond-operator>");
        payloadBuilder.append("<cond-values xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">simple-project</cond-values>");
        payloadBuilder.append("</query-params>");
        payloadBuilder.append("</task-query-filter-spec>");
        return payloadBuilder.toString();
    }

    private static TaskInstanceList getTaskInstanceList() {
        return new TaskInstanceList();
    }
}

