/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.kie.server.remote.rest.jbpm.DefinitionResource;
import org.kie.server.remote.rest.jbpm.ProcessResource;
import org.kie.server.remote.rest.jbpm.RuntimeDataResource;
import org.kie.server.remote.rest.jbpm.UserTaskResource;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;

public class JbpmRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final String OWNER_EXTENSION = "jBPM";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!OWNER_EXTENSION.equals(extension)) {
            return Collections.emptyList();
        }
        ProcessService processService = null;
        RuntimeDataService runtimeDataService = null;
        DefinitionService definitionService = null;
        UserTaskService userTaskService = null;
        KieServerRegistry context = null;
        for (Object object : services) {
            if (ProcessService.class.isAssignableFrom(object.getClass())) {
                processService = (ProcessService)object;
                continue;
            }
            if (RuntimeDataService.class.isAssignableFrom(object.getClass())) {
                runtimeDataService = (RuntimeDataService)object;
                continue;
            }
            if (DefinitionService.class.isAssignableFrom(object.getClass())) {
                definitionService = (DefinitionService)object;
                continue;
            }
            if (UserTaskService.class.isAssignableFrom(object.getClass())) {
                userTaskService = (UserTaskService)object;
                continue;
            }
            if (!KieServerRegistry.class.isAssignableFrom(object.getClass())) continue;
            context = (KieServerRegistry)object;
        }
        ArrayList<Object> components = new ArrayList<Object>(4);
        components.add(new ProcessResource(processService, definitionService, runtimeDataService, context));
        components.add(new RuntimeDataResource(runtimeDataService, context));
        components.add(new DefinitionResource(definitionService));
        components.add(new UserTaskResource(userTaskService, context));
        return components;
    }
}

