/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.server.api.model.instance.TaskAttachment;
import org.kie.server.api.model.instance.TaskAttachmentList;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskCommentList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.remote.rest.common.exception.ExecutionServerRestOperationException;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/server")
public class UserTaskResource {
    public static final Logger logger = LoggerFactory.getLogger(UserTaskResource.class);
    private static final Boolean BYPASS_AUTH_USER = Boolean.parseBoolean(System.getProperty("org.kie.server.bypass.auth.user", "false"));
    private IdentityProvider identityProvider;
    private UserTaskService userTaskService;
    private MarshallerHelper marshallerHelper;

    public UserTaskResource(UserTaskService userTaskService, KieServerRegistry context) {
        this.userTaskService = userTaskService;
        this.identityProvider = context.getIdentityProvider();
        this.marshallerHelper = new MarshallerHelper(context);
    }

    protected String getUser(String queryParamUser) {
        if (BYPASS_AUTH_USER.booleanValue()) {
            return queryParamUser;
        }
        return this.identityProvider.getName();
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/activated")
    @Produces(value={"application/xml", "application/json"})
    public Response activate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to activate task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.activate(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/claimed")
    @Produces(value={"application/xml", "application/json"})
    public Response claim(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to claim task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.claim(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/completed")
    @Produces(value={"application/xml", "application/json"})
    public Response complete(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to unmarshal task outcome parameters from payload: '{}'", (Object)payload);
            Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, type, Map.class);
            logger.debug("About to complete task with id '{}' as user '{}' with data {}", new Object[]{taskId, userId, parameters});
            this.userTaskService.complete(taskId, userId, parameters);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/delegated")
    @Produces(value={"application/xml", "application/json"})
    public Response delegate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to delegate task with id '{}' as user '{}' to user '{}'", new Object[]{taskId, userId, targetUserId});
            this.userTaskService.delegate(taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/exited")
    @Produces(value={"application/xml", "application/json"})
    public Response exit(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to exit task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.exit(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/failed")
    @Produces(value={"application/xml", "application/json"})
    public Response fail(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to unmarshal task failure data from payload: '{}'", (Object)payload);
            Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, type, Map.class);
            logger.debug("About to fail task with id '{}' as user '{}' with data {}", new Object[]{taskId, userId, parameters});
            this.userTaskService.fail(taskId, userId, parameters);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/forwarded")
    @Produces(value={"application/xml", "application/json"})
    public Response forward(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to forward task with id '{}' as user '{}' to user '{}'", new Object[]{taskId, userId, targetUserId});
            this.userTaskService.forward(taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/released")
    @Produces(value={"application/xml", "application/json"})
    public Response release(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to release task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.release(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/resumed")
    @Produces(value={"application/xml", "application/json"})
    public Response resume(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to resume task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.resume(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/skipped")
    @Produces(value={"application/xml", "application/json"})
    public Response skip(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to skip task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.skip(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/started")
    @Produces(value={"application/xml", "application/json"})
    public Response start(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to start task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.start(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/stopped")
    @Produces(value={"application/xml", "application/json"})
    public Response stop(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to stop task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.stop(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/suspended")
    @Produces(value={"application/xml", "application/json"})
    public Response suspend(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to suspend task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
            this.userTaskService.suspend(taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/states/nominated")
    @Produces(value={"application/xml", "application/json"})
    public Response nominate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, @QueryParam(value="potOwner") List<String> potentialOwners) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to nominate task with id '{}' as user '{}' to potential owners", new Object[]{taskId, userId, potentialOwners});
            ArrayList<User> potOwnerEntities = new ArrayList<User>();
            for (String potOwnerId : potentialOwners) {
                potOwnerEntities.add(TaskModelProvider.getFactory().newUser(potOwnerId));
            }
            this.userTaskService.nominate(taskId, userId, potOwnerEntities);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/priority")
    @Produces(value={"application/xml", "application/json"})
    public Response setPriority(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String priorityPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task priority from payload: '{}'", (Object)priorityPayload);
            Integer priority = (Integer)this.marshallerHelper.unmarshal(containerId, priorityPayload, type, Integer.class);
            logger.debug("About to set priority for a task with id '{}' with value '{}'", (Object)taskId, (Object)priority);
            this.userTaskService.setPriority(taskId, priority.intValue());
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/expiration")
    @Produces(value={"application/xml", "application/json"})
    public Response setExpirationDate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String datePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task priority from payload: '{}'", (Object)datePayload);
            Date expirationDate = (Date)this.marshallerHelper.unmarshal(containerId, datePayload, type, Date.class);
            logger.debug("About to set expiration date for a task with id '{}' with value '{}'", (Object)taskId, (Object)expirationDate);
            this.userTaskService.setExpirationDate(taskId, expirationDate);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/skipable")
    @Produces(value={"application/xml", "application/json"})
    public Response setSkipable(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String skipablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task skipable from payload: '{}'", (Object)skipablePayload);
            Boolean skipable = (Boolean)this.marshallerHelper.unmarshal(containerId, skipablePayload, type, Boolean.class);
            logger.debug("About to set skipable attribute for a task with id '{}' with value '{}'", (Object)taskId, (Object)skipable);
            this.userTaskService.setSkipable(taskId, skipable.booleanValue());
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/name")
    @Produces(value={"application/xml", "application/json"})
    public Response setName(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String namePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task name from payload: '{}'", (Object)namePayload);
            String name = (String)this.marshallerHelper.unmarshal(containerId, namePayload, type, String.class);
            logger.debug("About to set name for a task with id '{}' with value '{}'", (Object)taskId, (Object)name);
            this.userTaskService.setName(taskId, name);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/description")
    @Produces(value={"application/xml", "application/json"})
    public Response setDescription(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String descriptionPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task description from payload: '{}'", (Object)descriptionPayload);
            String description = (String)this.marshallerHelper.unmarshal(containerId, descriptionPayload, type, String.class);
            logger.debug("About to set name for a task with id '{}' with value '{}'", (Object)taskId, (Object)description);
            this.userTaskService.setDescription(taskId, description);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/tasks/{tInstanceId}/content/output")
    @Produces(value={"application/xml", "application/json"})
    public Response saveContent(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task content parameters from payload: '{}'", (Object)payload);
            Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, type, Map.class);
            logger.debug("About to set content of a task with id '{}' with data {}", (Object)taskId, (Object)parameters);
            Long contentId = this.userTaskService.saveContent(taskId, parameters);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)contentId);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}/content/output")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskOutputContentByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Map variables = this.userTaskService.getTaskOutputContentByTaskId(taskId);
            logger.debug("About to marshal task '{}' output variables {}", (Object)taskId, (Object)variables);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)variables);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}/content/input")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskInputContentByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Map variables = this.userTaskService.getTaskInputContentByTaskId(taskId);
            logger.debug("About to marshal task '{}' input variables {}", (Object)taskId, (Object)variables);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)variables);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="containers/{id}/tasks/{tInstanceId}/content/{contentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteContent(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="contentId") Long contentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskService.deleteContent(taskId, contentId);
            return null;
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="containers/{id}/tasks/{tInstanceId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response addComment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task comment from payload: '{}'", (Object)payload);
            TaskComment comment = (TaskComment)this.marshallerHelper.unmarshal(containerId, payload, type, TaskComment.class);
            logger.debug("About to set comment on a task with id '{}' with data {}", (Object)taskId, (Object)comment);
            Long commentId = this.userTaskService.addComment(taskId, comment.getText(), comment.getAddedBy(), comment.getAddedAt());
            String response = this.marshallerHelper.marshal(containerId, type, (Object)commentId);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="containers/{id}/tasks/{tInstanceId}/comments/{commentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteComment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskService.deleteComment(taskId, commentId);
            return null;
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response getCommentsByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            List comments = this.userTaskService.getCommentsByTaskId(taskId);
            TaskComment[] taskComments = new TaskComment[comments.size()];
            int counter = 0;
            for (Comment comment : comments) {
                TaskComment taskComment;
                taskComments[counter] = taskComment = TaskComment.builder().id(comment.getId()).text(comment.getText()).addedBy(comment.getAddedBy().getId()).addedAt(comment.getAddedAt()).build();
                ++counter;
            }
            TaskCommentList result = new TaskCommentList(taskComments);
            logger.debug("About to marshal task '{}' comments {}", (Object)taskId, (Object)result);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)result);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}/comments/{commentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCommentById(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Comment comment = this.userTaskService.getCommentById(taskId, commentId);
            if (comment == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task comment with id \"{0}\" attached to task with id \"{1}\"", commentId, taskId), (Variant)v);
            }
            TaskComment taskComment = TaskComment.builder().id(comment.getId()).text(comment.getText()).addedBy(comment.getAddedBy().getId()).addedAt(comment.getAddedAt()).build();
            logger.debug("About to marshal task '{}' comment {}", (Object)taskId, (Object)taskComment);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)taskComment);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="containers/{id}/tasks/{tInstanceId}/attachments")
    @Produces(value={"application/xml", "application/json"})
    public Response addAttachment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, String attachmentPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal task attachment from payload: '{}'", (Object)attachmentPayload);
            Object attachment = this.marshallerHelper.unmarshal(containerId, attachmentPayload, type, Object.class);
            logger.debug("About to add attachment on a task with id '{}' with data {}", (Object)taskId, attachment);
            Long attachmentId = this.userTaskService.addAttachment(taskId, this.getUser(userId), attachment);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)attachmentId);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="containers/{id}/tasks/{tInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteAttachment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskService.deleteAttachment(taskId, attachmentId);
            return null;
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentById(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Attachment attachment = this.userTaskService.getAttachmentById(taskId, attachmentId);
            TaskAttachment taskAttachment = TaskAttachment.builder().id(attachment.getId()).name(attachment.getName()).addedBy(attachment.getAttachedBy().getId()).addedAt(attachment.getAttachedAt()).attachmentContentId(Long.valueOf(attachment.getAttachmentContentId())).contentType(attachment.getContentType()).size(Integer.valueOf(attachment.getSize())).build();
            logger.debug("About to marshal task '{}' attachment {} with content {}", new Object[]{taskId, attachmentId, taskAttachment});
            String response = this.marshallerHelper.marshal(containerId, type, (Object)taskAttachment);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}/attachments/{attachmentId}/content")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentContentById(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Object attachment = this.userTaskService.getAttachmentContentById(taskId, attachmentId);
            if (attachment == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task attachment with id \"{0}\" attached to task with id \"{1}\"", attachmentId, taskId), (Variant)v);
            }
            logger.debug("About to marshal task attachment with id '{}' {}", (Object)attachmentId, attachment);
            String response = this.marshallerHelper.marshal(containerId, type, attachment);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}/attachments")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentsByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            List attachments = this.userTaskService.getAttachmentsByTaskId(taskId);
            TaskAttachment[] taskComments = new TaskAttachment[attachments.size()];
            int counter = 0;
            for (Attachment attachment : attachments) {
                TaskAttachment taskComment;
                taskComments[counter] = taskComment = TaskAttachment.builder().id(attachment.getId()).name(attachment.getName()).addedBy(attachment.getAttachedBy().getId()).addedAt(attachment.getAttachedAt()).contentType(attachment.getContentType()).attachmentContentId(Long.valueOf(attachment.getAttachmentContentId())).size(Integer.valueOf(attachment.getSize())).build();
                ++counter;
            }
            TaskAttachmentList result = new TaskAttachmentList(taskComments);
            logger.debug("About to marshal task '{}' attachments {}", (Object)taskId, (Object)result);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)result);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/tasks/{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTask(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="withInputData") boolean withInput, @QueryParam(value="withOutputData") boolean withOutput, @QueryParam(value="withAssignments") boolean withAssignments) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Map variables;
            Task task = this.userTaskService.getTask(taskId);
            TaskInstance.Builder builder = TaskInstance.builder();
            builder.id(task.getId()).name(task.getName()).subject(task.getSubject()).description(task.getDescription()).priority(Integer.valueOf(task.getPriority())).taskType(task.getTaskType()).formName(((InternalTask)task).getFormName()).status(task.getTaskData().getStatus().name()).actualOwner(this.getOrgEntityIfNotNull((OrganizationalEntity)task.getTaskData().getActualOwner())).createdBy(this.getOrgEntityIfNotNull((OrganizationalEntity)task.getTaskData().getCreatedBy())).createdOn(task.getTaskData().getCreatedOn()).activationTime(task.getTaskData().getActivationTime()).expirationTime(task.getTaskData().getExpirationTime()).skippable(Boolean.valueOf(task.getTaskData().isSkipable())).workItemId(Long.valueOf(task.getTaskData().getWorkItemId())).processInstanceId(Long.valueOf(task.getTaskData().getProcessInstanceId())).parentId(Long.valueOf(task.getTaskData().getParentId())).processId(task.getTaskData().getProcessId()).containerId(task.getTaskData().getDeploymentId());
            if (Boolean.TRUE.equals(withInput)) {
                variables = this.userTaskService.getTaskInputContentByTaskId(taskId);
                builder.inputData(variables);
            }
            if (Boolean.TRUE.equals(withOutput)) {
                variables = this.userTaskService.getTaskOutputContentByTaskId(taskId);
                builder.outputData(variables);
            }
            if (Boolean.TRUE.equals(withAssignments)) {
                builder.potentialOwners(this.orgEntityAsList(task.getPeopleAssignments().getPotentialOwners()));
                builder.excludedOwners(this.orgEntityAsList(((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners()));
                builder.businessAdmins(this.orgEntityAsList(task.getPeopleAssignments().getBusinessAdministrators()));
            }
            TaskInstance taskInstance = builder.build();
            logger.debug("About to marshal task '{}' representation {}", (Object)taskId, (Object)taskInstance);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)taskInstance);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    private String getOrgEntityIfNotNull(OrganizationalEntity organizationalEntity) {
        if (organizationalEntity == null) {
            return "";
        }
        return organizationalEntity.getId();
    }

    private List<String> orgEntityAsList(List<OrganizationalEntity> organizationalEntities) {
        ArrayList<String> entities = new ArrayList<String>();
        if (organizationalEntities == null) {
            return entities;
        }
        for (OrganizationalEntity entity : organizationalEntities) {
            entities.add(entity.getId());
        }
        return entities;
    }
}

