/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.definition.AssociatedEntitiesDefinition;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ServiceTasksDefinition;
import org.kie.server.api.model.definition.SubProcessesDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.definition.VariablesDefinition;
import org.kie.server.remote.rest.common.exception.ExecutionServerRestOperationException;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.jbpm.DefinitionServiceBase;

@Path(value="server/containers/{id}/processes/definitions")
public class DefinitionResource {
    private DefinitionServiceBase definitionServiceBase;

    public DefinitionResource(DefinitionServiceBase definitionServiceBase) {
        this.definitionServiceBase = definitionServiceBase;
    }

    @GET
    @Path(value="{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessDefinition(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            ProcessDefinition responseObject = this.definitionServiceBase.getProcessDefinition(containerId, processId);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{pId}/subprocesses")
    @Produces(value={"application/xml", "application/json"})
    public Response getReusableSubProcesses(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            SubProcessesDefinition definition = this.definitionServiceBase.getReusableSubProcesses(containerId, processId);
            return RestUtils.createCorrectVariant((Object)definition, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{pId}/variables")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessVariables(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            VariablesDefinition variablesDefinition = this.definitionServiceBase.getProcessVariables(containerId, processId);
            return RestUtils.createCorrectVariant((Object)variablesDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{pId}/tasks/service")
    @Produces(value={"application/xml", "application/json"})
    public Response getServiceTasks(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            ServiceTasksDefinition serviceTasksDefinition = this.definitionServiceBase.getServiceTasks(containerId, processId);
            return RestUtils.createCorrectVariant((Object)serviceTasksDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{pId}/entities")
    @Produces(value={"application/xml", "application/json"})
    public Response getAssociatedEntities(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            AssociatedEntitiesDefinition associatedEntitiesDefinition = this.definitionServiceBase.getAssociatedEntities(containerId, processId);
            return RestUtils.createCorrectVariant((Object)associatedEntitiesDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{pId}/tasks/users")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksDefinitions(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            UserTaskDefinitionList userTaskDefinitions = this.definitionServiceBase.getTasksDefinitions(containerId, processId);
            return RestUtils.createCorrectVariant((Object)userTaskDefinitions, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{pId}/tasks/users/{taskName}/inputs")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskInputMappings(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @PathParam(value="taskName") String taskName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            TaskInputsDefinition taskInputsDefinition = this.definitionServiceBase.getTaskInputMappings(containerId, processId, taskName);
            return RestUtils.createCorrectVariant((Object)taskInputsDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{pId}/tasks/users/{taskName}/outputs")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskOutputMappings(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @PathParam(value="taskName") String taskName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            TaskOutputsDefinition taskOutputsDefinition = this.definitionServiceBase.getTaskOutputMappings(containerId, processId, taskName);
            return RestUtils.createCorrectVariant((Object)taskOutputsDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }
}

