/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.TaskNotFoundException;
import org.kie.server.remote.rest.common.exception.ExecutionServerRestOperationException;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.jbpm.UserTaskServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/containers/{id}/tasks")
public class UserTaskResource {
    public static final Logger logger = LoggerFactory.getLogger(UserTaskResource.class);
    private UserTaskServiceBase userTaskServiceBase;

    public UserTaskResource(UserTaskServiceBase userTaskServiceBase) {
        this.userTaskServiceBase = userTaskServiceBase;
    }

    @PUT
    @Path(value="{tInstanceId}/states/activated")
    @Produces(value={"application/xml", "application/json"})
    public Response activate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.activate(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/claimed")
    @Produces(value={"application/xml", "application/json"})
    public Response claim(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.claim(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/completed")
    @Produces(value={"application/xml", "application/json"})
    public Response complete(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.complete(containerId, (Number)taskId, userId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/delegated")
    @Produces(value={"application/xml", "application/json"})
    public Response delegate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.delegate(containerId, (Number)taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/exited")
    @Produces(value={"application/xml", "application/json"})
    public Response exit(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.exit(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/failed")
    @Produces(value={"application/xml", "application/json"})
    public Response fail(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.fail(containerId, (Number)taskId, userId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/forwarded")
    @Produces(value={"application/xml", "application/json"})
    public Response forward(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.forward(containerId, (Number)taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/released")
    @Produces(value={"application/xml", "application/json"})
    public Response release(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.release(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/resumed")
    @Produces(value={"application/xml", "application/json"})
    public Response resume(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.resume(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/skipped")
    @Produces(value={"application/xml", "application/json"})
    public Response skip(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.skip(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/started")
    @Produces(value={"application/xml", "application/json"})
    public Response start(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.start(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/stopped")
    @Produces(value={"application/xml", "application/json"})
    public Response stop(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.stop(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/suspended")
    @Produces(value={"application/xml", "application/json"})
    public Response suspend(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.suspend(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/states/nominated")
    @Produces(value={"application/xml", "application/json"})
    public Response nominate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, @QueryParam(value="potOwner") List<String> potentialOwners) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.nominate(containerId, (Number)taskId, userId, potentialOwners);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/priority")
    @Produces(value={"application/xml", "application/json"})
    public Response setPriority(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String priorityPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setPriority(containerId, (Number)taskId, priorityPayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/expiration")
    @Produces(value={"application/xml", "application/json"})
    public Response setExpirationDate(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String datePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setExpirationDate(containerId, (Number)taskId, datePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/skipable")
    @Produces(value={"application/xml", "application/json"})
    public Response setSkipable(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String skipablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setSkipable(containerId, (Number)taskId, skipablePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/name")
    @Produces(value={"application/xml", "application/json"})
    public Response setName(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String namePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setName(containerId, (Number)taskId, namePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/description")
    @Produces(value={"application/xml", "application/json"})
    public Response setDescription(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String descriptionPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setDescription(containerId, (Number)taskId, descriptionPayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{tInstanceId}/contents/output")
    @Produces(value={"application/xml", "application/json"})
    public Response saveContent(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.saveContent(containerId, (Number)taskId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}/contents/output")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskOutputContentByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTaskOutputContentByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}/contents/input")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskInputContentByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTaskInputContentByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="{tInstanceId}/contents/{contentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteContent(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="contentId") Long contentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteContent(containerId, (Number)taskId, (Number)contentId);
            return null;
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="{tInstanceId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response addComment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.addComment(containerId, (Number)taskId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="{tInstanceId}/comments/{commentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteComment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteComment(containerId, (Number)taskId, (Number)commentId);
            return null;
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response getCommentsByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getCommentsByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}/comments/{commentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCommentById(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getCommentById(containerId, (Number)taskId, (Number)commentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="{tInstanceId}/attachments")
    @Produces(value={"application/xml", "application/json"})
    public Response addAttachment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="user") String userId, @QueryParam(value="name") String name, String attachmentPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.addAttachment(containerId, (Number)taskId, userId, name, attachmentPayload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="{tInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteAttachment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteAttachment(containerId, (Number)taskId, (Number)attachmentId);
            return null;
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentById(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentById(containerId, (Number)taskId, (Number)attachmentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}/attachments/{attachmentId}/content")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentContentById(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentContentById(containerId, (Number)taskId, (Number)attachmentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}/attachments")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentsByTaskId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentsByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTask(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="withInputData") boolean withInput, @QueryParam(value="withOutputData") boolean withOutput, @QueryParam(value="withAssignments") boolean withAssignments) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTask(containerId, (Number)taskId, withInput, withOutput, withAssignments, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (TaskNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }
}

