/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.instance.DocumentInstance;
import org.kie.server.api.model.instance.DocumentInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieServerRuntimeException;
import org.kie.server.services.jbpm.DocumentServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/documents")
public class DocumentResource {
    public static final Logger logger = LoggerFactory.getLogger(DocumentResource.class);
    private DocumentServiceBase documentServiceBase;
    private KieServerRegistry context;

    public DocumentResource() {
    }

    public DocumentResource(DocumentServiceBase documentServiceBase, KieServerRegistry context) {
        this.documentServiceBase = documentServiceBase;
        this.context = context;
    }

    @GET
    @Path(value="{documentId}/content")
    @Produces(value={"application/octet-stream"})
    public Response getDocumentContent(@Context HttpHeaders headers, @PathParam(value="documentId") String documentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            final DocumentInstance document = this.documentServiceBase.getDocument(documentId);
            if (document == null) {
                return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            StreamingOutput entity = new StreamingOutput(){

                public void write(OutputStream output) throws IOException, WebApplicationException {
                    output.write(document.getContent());
                }
            };
            if (conversationIdHeader != null) {
                return Response.ok().entity((Object)entity).header(conversationIdHeader.getName(), (Object)conversationIdHeader.getValue()).build();
            }
            return Response.ok().entity((Object)entity).build();
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="{documentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getDocument(@Context HttpHeaders headers, @PathParam(value="documentId") String documentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            DocumentInstance document = this.documentServiceBase.getDocument(documentId);
            return RestUtils.createCorrectVariant((Object)document, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (KieServerRuntimeException e) {
            return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response listDocuments(@Context HttpHeaders headers, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            DocumentInstanceList documents = this.documentServiceBase.listDocuments(page, pageSize);
            return RestUtils.createCorrectVariant((Object)documents, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response createDocument(@Context HttpHeaders headers, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String identifier = this.documentServiceBase.storeDocument(payload, type);
            return RestUtils.createCorrectVariant((Object)identifier, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @PUT
    @Path(value="{documentId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateDocument(@Context HttpHeaders headers, @PathParam(value="documentId") String documentId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.documentServiceBase.updateDocument(documentId, payload, type);
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (KieServerRuntimeException e) {
            return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @DELETE
    @Path(value="{documentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteDocument(@Context HttpHeaders headers, @PathParam(value="documentId") String documentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.documentServiceBase.deleteDocument(documentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (KieServerRuntimeException e) {
            return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

