/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.query.QueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.server.remote.rest.jbpm.DefinitionResource;
import org.kie.server.remote.rest.jbpm.DocumentResource;
import org.kie.server.remote.rest.jbpm.ExecutorResource;
import org.kie.server.remote.rest.jbpm.ProcessResource;
import org.kie.server.remote.rest.jbpm.QueryDataResource;
import org.kie.server.remote.rest.jbpm.RuntimeDataResource;
import org.kie.server.remote.rest.jbpm.UserTaskResource;
import org.kie.server.remote.rest.jbpm.admin.ProcessAdminResource;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.jbpm.DefinitionServiceBase;
import org.kie.server.services.jbpm.DocumentServiceBase;
import org.kie.server.services.jbpm.ExecutorServiceBase;
import org.kie.server.services.jbpm.ProcessServiceBase;
import org.kie.server.services.jbpm.QueryDataServiceBase;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.kie.server.services.jbpm.UserTaskServiceBase;
import org.kie.server.services.jbpm.admin.ProcessAdminServiceBase;

public class JbpmRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final String OWNER_EXTENSION = "jBPM";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!OWNER_EXTENSION.equals(extension)) {
            return Collections.emptyList();
        }
        ProcessService processService = null;
        RuntimeDataService runtimeDataService = null;
        DefinitionService definitionService = null;
        UserTaskService userTaskService = null;
        ExecutorService executorService = null;
        QueryService queryService = null;
        ProcessInstanceMigrationService processInstanceMigrationService = null;
        KieServerRegistry context = null;
        for (Object object : services) {
            if (object == null) continue;
            if (ProcessService.class.isAssignableFrom(object.getClass())) {
                processService = (ProcessService)object;
                continue;
            }
            if (RuntimeDataService.class.isAssignableFrom(object.getClass())) {
                runtimeDataService = (RuntimeDataService)object;
                continue;
            }
            if (DefinitionService.class.isAssignableFrom(object.getClass())) {
                definitionService = (DefinitionService)object;
                continue;
            }
            if (UserTaskService.class.isAssignableFrom(object.getClass())) {
                userTaskService = (UserTaskService)object;
                continue;
            }
            if (ExecutorService.class.isAssignableFrom(object.getClass())) {
                executorService = (ExecutorService)object;
                continue;
            }
            if (QueryService.class.isAssignableFrom(object.getClass())) {
                queryService = (QueryService)object;
                continue;
            }
            if (ProcessInstanceMigrationService.class.isAssignableFrom(object.getClass())) {
                processInstanceMigrationService = (ProcessInstanceMigrationService)object;
                continue;
            }
            if (!KieServerRegistry.class.isAssignableFrom(object.getClass())) continue;
            context = (KieServerRegistry)object;
        }
        ArrayList<Object> components = new ArrayList<Object>(6);
        DefinitionServiceBase definitionServiceBase = new DefinitionServiceBase(definitionService);
        ProcessServiceBase processServiceBase = new ProcessServiceBase(processService, definitionService, runtimeDataService, context);
        UserTaskServiceBase userTaskServiceBase = new UserTaskServiceBase(userTaskService, context);
        RuntimeDataServiceBase runtimeDataServiceBase = new RuntimeDataServiceBase(runtimeDataService, context);
        ExecutorServiceBase executorServiceBase = new ExecutorServiceBase(executorService, context);
        QueryDataServiceBase queryDataServiceBase = new QueryDataServiceBase(queryService, context);
        DocumentServiceBase documentServiceBase = new DocumentServiceBase(context);
        ProcessAdminServiceBase processAdminServiceBase = new ProcessAdminServiceBase(processInstanceMigrationService, context);
        components.add(new ProcessResource(processServiceBase, definitionServiceBase, runtimeDataServiceBase, context));
        components.add(new RuntimeDataResource(runtimeDataServiceBase, context));
        components.add(new DefinitionResource(definitionServiceBase, context));
        components.add(new UserTaskResource(userTaskServiceBase, context));
        components.add(new ExecutorResource(executorServiceBase, context));
        components.add(new QueryDataResource(queryDataServiceBase, context));
        components.add(new DocumentResource(documentServiceBase, context));
        components.add(new ProcessAdminResource(processAdminServiceBase, context));
        return components;
    }
}

