/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.admin;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.NodeInstanceNotFoundException;
import org.jbpm.services.api.NodeNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.admin.ExecutionErrorNotFoundException;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.MigrationReportInstance;
import org.kie.server.api.model.admin.MigrationReportInstanceList;
import org.kie.server.api.model.admin.ProcessNodeList;
import org.kie.server.api.model.admin.TimerInstanceList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.admin.ProcessAdminServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Process instances administration :: BPM")
@Path(value="server/admin/containers/{id}/processes")
public class ProcessAdminResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAdminResource.class);
    private ProcessAdminServiceBase processAdminServiceBase;
    private KieServerRegistry context;

    public ProcessAdminResource() {
    }

    public ProcessAdminResource(ProcessAdminServiceBase processAdminServiceBase, KieServerRegistry context) {
        this.processAdminServiceBase = processAdminServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Migrates process instance to new container and process definition with optional node mapping", response=MigrationReportInstance.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found")})
    @PUT
    @Path(value="instances/{pInstanceId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response migrateProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance to be migrated", required=true) @PathParam(value="pInstanceId") Long processInstanceId, @ApiParam(value="container id that new process definition belongs to", required=true) @QueryParam(value="targetContainerId") String targetContainerId, @ApiParam(value="process definition that process instance should be migrated to", required=true) @QueryParam(value="targetProcessId") String targetProcessId, @ApiParam(value="node mapping - unique ids of old definition to new definition given as Map", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"name\": \"john\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>name</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">john</value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            MigrationReportInstance reportInstance = this.processAdminServiceBase.migrateProcessInstance(containerId, (Number)processInstanceId, targetContainerId, targetProcessId, payload, type);
            return RestUtils.createCorrectVariant((Object)reportInstance, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Migrates process instances to new container and process definition with optional node mapping", response=MigrationReportInstanceList.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found")})
    @PUT
    @Path(value="instances")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response migrateProcessInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instances belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="list of identifiers of process instance to be migrated", required=true) @QueryParam(value="pInstanceId") List<Long> processInstanceIds, @ApiParam(value="container id that new process definition belongs to", required=true) @QueryParam(value="targetContainerId") String targetContainerId, @ApiParam(value="process definition that process instances should be migrated to", required=true) @QueryParam(value="targetProcessId") String targetProcessId, @ApiParam(value="node mapping - unique ids of old definition to new definition given as Map", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"name\": \"john\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>name</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">john</value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            MigrationReportInstanceList reportInstances = this.processAdminServiceBase.migrateProcessInstances(containerId, processInstanceIds, targetContainerId, targetProcessId, payload, type);
            return RestUtils.createCorrectVariant((Object)reportInstances, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceIds), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Cancels given node instance within process instance and container", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @DELETE
    @Path(value="instances/{pInstanceId}/nodeinstances/{nodeInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelNodeInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance that node instance belongs to", required=true) @PathParam(value="pInstanceId") Long processInstanceId, @ApiParam(value="identifier of node instance that should be canceled", required=true) @PathParam(value="nodeInstanceId") Long nodeInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.cancelNodeInstance(containerId, (Number)processInstanceId, (Number)nodeInstanceId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", nodeInstanceId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retriggers given node instance within process instance and container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @PUT
    @Path(value="instances/{pInstanceId}/nodeinstances/{nodeInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response retriggerNodeInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance that node instance belongs to", required=true) @PathParam(value="pInstanceId") Long processInstanceId, @ApiParam(value="identifier of node instance that should be retriggered", required=true) @PathParam(value="nodeInstanceId") Long nodeInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.retriggerNodeInstance(containerId, (Number)processInstanceId, (Number)nodeInstanceId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", nodeInstanceId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates timer instance within process instance and container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @PUT
    @Path(value="instances/{pInstanceId}/timers/{timerId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateTimer(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance that timer belongs to", required=true) @PathParam(value="pInstanceId") Long processInstanceId, @ApiParam(value="identifier of timer instance to be updated", required=true) @PathParam(value="timerId") Long timerId, @ApiParam(value="optional flag that indicates if the time expression is relative to the current date or not, defaults to true", required=false) @QueryParam(value="relative") @DefaultValue(value="true") boolean relative, @ApiParam(value="Map of timer expressions - deplay, perios and repeat are allowed values in the map", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"period\" : 0,\n  \"delay\" : 3,\n  \"repeatLimit\" : 0\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>period</key>\n            <value xsi:type=\"xs:long\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">0</value>\n        </entry>\n        <entry>\n            <key>delay</key>\n            <value xsi:type=\"xs:long\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">3</value>\n        </entry>\n        <entry>\n            <key>repeatLimit</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">0</value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.updateTimer(containerId, (Number)processInstanceId, (Number)timerId, relative, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find timer instance with id \"{0}\" within process instance with id \"{1}\"", timerId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Triggers node within process instance and container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @POST
    @Path(value="instances/{pInstanceId}/nodes/{nodeId}")
    @Produces(value={"application/xml", "application/json"})
    public Response triggerNode(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance where node should be triggered", required=true) @PathParam(value="pInstanceId") Long processInstanceId, @ApiParam(value="identifier of the node to be triggered", required=true) @PathParam(value="nodeId") Long nodeId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.triggerNode(containerId, (Number)processInstanceId, (Number)nodeId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node with id \"{0}\" within process instance with id \"{1}\"", nodeId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves all active timer instance from process instance and container", response=TimerInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found")})
    @GET
    @Path(value="instances/{pInstanceId}/timers")
    @Produces(value={"application/xml", "application/json"})
    public Response getTimerInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance that timer instances should be collected for", required=true) @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TimerInstanceList timerInstanceList = this.processAdminServiceBase.getTimerInstances(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)timerInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves all active node instances from process instance and container", response=NodeInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found")})
    @GET
    @Path(value="instances/{pInstanceId}/nodeinstances")
    @Produces(value={"application/xml", "application/json"})
    public Response getActiveNodeInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance that active nodes instances should be collected for", required=true) @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            NodeInstanceList nodeInstanceList = this.processAdminServiceBase.getActiveNodeInstances(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves all nodes from process instance and container", response=ProcessNodeList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found")})
    @GET
    @Path(value="instances/{pInstanceId}/nodes")
    @Produces(value={"application/xml", "application/json"})
    public Response getNodes(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance that process nodes should be collected from", required=true) @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ProcessNodeList processNodeList = this.processAdminServiceBase.getProcessNodes(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)processNodeList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledge execution error by given id", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Execution error or Container Id not found")})
    @PUT
    @Path(value="errors/{errorId}")
    @Produces(value={"application/xml", "application/json"})
    public Response acknowledgeError(@Context HttpHeaders headers, @ApiParam(value="container id that error belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of error to be acknowledged", required=true) @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.acknowledgeError(containerId, Arrays.asList(errorId));
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledges given execution errors", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Execution error or Container Id not found")})
    @PUT
    @Path(value="errors")
    @Produces(value={"application/xml", "application/json"})
    public Response acknowledgeErrors(@Context HttpHeaders headers, @ApiParam(value="container id that errors belong to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="list of error identifiers to be acknowledged", required=true) @QueryParam(value="errorId") List<String> errorIds) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.acknowledgeError(containerId, errorIds);
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieve execution error by its identifier", response=ExecutionErrorInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found")})
    @GET
    @Path(value="errors/{errorId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrorById(@Context HttpHeaders headers, @ApiParam(value="container id that process error belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of error to be loaded", required=true) @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstance executionErrorInstance = this.processAdminServiceBase.getError(containerId, errorId);
            return RestUtils.createCorrectVariant((Object)executionErrorInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves execution errors for process instance and container, applies pagination", response=ExecutionErrorInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found")})
    @GET
    @Path(value="instances/{pInstanceId}/errors")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrorsByProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process instance that errors should be collected for", required=true) @PathParam(value="pInstanceId") Long processInstanceId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional name of the node in the process instance to filter by", required=false) @QueryParam(value="node") String nodeName, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.processAdminServiceBase.getExecutionErrorsByProcessInstance(containerId, (Number)processInstanceId, nodeName, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves execution errors for container, applies pagination", response=NodeInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found")})
    @GET
    @Path(value="errors")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrors(@Context HttpHeaders headers, @ApiParam(value="container id that errors belong to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.processAdminServiceBase.getExecutionErrors(containerId, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

