/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.api.model.instance.RequestInfoInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.ExecutorServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Jobs")
@Path(value="server/jobs")
public class ExecutorResource {
    public static final Logger logger = LoggerFactory.getLogger(ExecutorResource.class);
    private ExecutorServiceBase executorServiceBase;
    private KieServerRegistry context;

    public ExecutorResource() {
    }

    public ExecutorResource(ExecutorServiceBase executorServiceBase, KieServerRegistry context) {
        this.executorServiceBase = executorServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Schedules a job and returns the ID for the new job.", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=201, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="123")}))})
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response scheduleRequest(@Context HttpHeaders headers, @ApiParam(value="optional container id that the job should be associated with", required=false) @QueryParam(value="containerId") String containerId, @ApiParam(value="asynchronous job definition represented as JobRequestInstance", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"job-command\" : \"org.jbpm.executor.commands.PrintOutCommand\",\n  \"scheduled-date\" : {\n    \"java.util.Date\" : 1540023411655\n  },\n  \"request-data\" : {\n    \"businessKey\" : \"test key\"\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<job-request-instance>\n    <job-command>org.jbpm.executor.commands.PrintOutCommand</job-command>\n    <scheduled-date>2018-10-20T10:16:51.326+02:00</scheduled-date>\n    <data>\n        <entry>\n            <key>businessKey</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">test key</value>\n        </entry>\n    </data>\n</job-request-instance>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.executorServiceBase.scheduleRequest(containerId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid Command type ", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes a specified job.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @DELETE
    @Path(value="{jobId}")
    @Produces(value={"application/json", "application/xml"})
    public Response cancelRequest(@Context HttpHeaders headers, @ApiParam(value="identifier of the asynchronous job to be canceled", required=true, example="123") @PathParam(value="jobId") long requestId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.executorServiceBase.cancelRequest(requestId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Re-queues a specified job.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @PUT
    @Path(value="{jobId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response requeueRequest(@Context HttpHeaders headers, @ApiParam(value="identifier of the asynchronous job to be requeued", required=true, example="123") @PathParam(value="jobId") long requestId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.executorServiceBase.requeueRequest(requestId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates parameters for job commands, if used.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="{jobId}/data")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateRequestData(@Context HttpHeaders headers, @ApiParam(value="identifier of the asynchronous job to be updated", required=true, example="123") @PathParam(value="jobId") long requestId, @ApiParam(value="optional container id that the job should be associated with", required=false) @QueryParam(value="containerId") String containerId, @ApiParam(value="data to be updated on the asynchronous job represented as Map", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.executorServiceBase.updateRequestData(requestId, containerId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves asynchronous jobs filtered by status", response=RequestInfoInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"request-info-instance\": [\n    {\n      \"request-instance-id\": 1,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job1\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 2,\n      \"request-executions\": 1,\n      \"request-command\": \"org.jbpm.executor.commands.LogCleanupCommand\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540299058209\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    },\n    {\n      \"request-instance-id\": 2,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job2\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 0,\n      \"request-executions\": 0,\n      \"request-command\": \"java.lang.String\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540328449419\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    }\n  ]\n}")}))})
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getRequestsByStatus(@Context HttpHeaders headers, @ApiParam(value="optional job status (QUEUED, DONE, CANCELLED, ERROR, RETRYING, RUNNING)", required=true, allowableValues="QUEUED,DONE,CANCELLED,ERROR,RETRYING,RUNNING") @QueryParam(value="status") List<String> statuses, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = this.executorServiceBase.getRequestsByStatus(statuses, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a job with a specified business key.", response=RequestInfoInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"request-info-instance\": [\n    {\n      \"request-instance-id\": 1,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job1\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 2,\n      \"request-executions\": 1,\n      \"request-command\": \"org.jbpm.executor.commands.LogCleanupCommand\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540299058209\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    },\n    {\n      \"request-instance-id\": 2,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job2\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 0,\n      \"request-executions\": 0,\n      \"request-command\": \"java.lang.String\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540328449419\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="keys/{key}")
    @Produces(value={"application/json", "application/xml"})
    public Response getRequestsByBusinessKey(@Context HttpHeaders headers, @ApiParam(value="identifier of the business key that asynchornous jobs should be found for", required=true, example="custom-job") @PathParam(value="key") String businessKey, @ApiParam(value="optional job status (QUEUED, DONE, CANCELLED, ERROR, RETRYING, RUNNING)", required=false, allowableValues="QUEUED,DONE,CANCELLED,ERROR,RETRYING,RUNNING") @QueryParam(value="status") List<String> statuses, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = null;
            result = statuses == null || statuses.isEmpty() ? this.executorServiceBase.getRequestsByBusinessKey(businessKey, page, pageSize) : this.executorServiceBase.getRequestsByBusinessKey(businessKey, statuses, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns jobs configured to run job commands, such as a job type org.jbpm.executor.commands.LogCleanupCommand.", response=RequestInfoInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"request-info-instance\": [\n    {\n      \"request-instance-id\": 1,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job1\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 2,\n      \"request-executions\": 1,\n      \"request-command\": \"org.jbpm.executor.commands.LogCleanupCommand\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540299058209\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    },\n    {\n      \"request-instance-id\": 2,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job2\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 0,\n      \"request-executions\": 0,\n      \"request-command\": \"java.lang.String\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540328449419\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="commands/{cmd}")
    @Produces(value={"application/json", "application/xml"})
    public Response getRequestsByCommand(@Context HttpHeaders headers, @ApiParam(value="name of the command that asynchornous jobs should be found for", required=true, example="com.sample.CommandImpl") @PathParam(value="cmd") String command, @ApiParam(value="optional job status (QUEUED, DONE, CANCELLED, ERROR, RETRYING, RUNNING)", required=false, allowableValues="QUEUED,DONE,CANCELLED,ERROR,RETRYING,RUNNING") @QueryParam(value="status") List<String> statuses, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = null;
            result = statuses == null || statuses.isEmpty() ? this.executorServiceBase.getRequestsByCommand(command, page, pageSize) : this.executorServiceBase.getRequestsByCommand(command, statuses, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns jobs for specified KIE container.", response=RequestInfoInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"request-info-instance\": [\n    {\n      \"request-instance-id\": 1,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job1\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 2,\n      \"request-executions\": 1,\n      \"request-command\": \"org.jbpm.executor.commands.LogCleanupCommand\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540299058209\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    },\n    {\n      \"request-instance-id\": 2,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job2\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 0,\n      \"request-executions\": 0,\n      \"request-command\": \"java.lang.String\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540328449419\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="containers/{containerId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getRequestsByContainer(@Context HttpHeaders headers, @ApiParam(value="identifier of the container that asynchornous jobs should be found for", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional job status (QUEUED, DONE, CANCELLED, ERROR, RETRYING, RUNNING)", required=false, allowableValues="QUEUED,DONE,CANCELLED,ERROR,RETRYING,RUNNING") @QueryParam(value="status") List<String> statuses, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = this.executorServiceBase.getRequestsByContainer(containerId, statuses, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns jobs for specified process instance.", response=RequestInfoInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"request-info-instance\": [\n    {\n      \"request-instance-id\": 1,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job1\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 2,\n      \"request-executions\": 1,\n      \"request-command\": \"org.jbpm.executor.commands.LogCleanupCommand\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540299058209\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    },\n    {\n      \"request-instance-id\": 2,\n      \"request-status\": \"DONE\",\n      \"request-business-key\": \"job2\",\n      \"request-message\": \"Ready to execute\",\n      \"request-retries\": 0,\n      \"request-executions\": 0,\n      \"request-command\": \"java.lang.String\",\n      \"request-scheduled-date\": {\n        \"java.util.Date\": 1540328449419\n      },\n      \"request-data\": null,\n      \"response-data\": null,\n      \"request-errors\": null,\n      \"request-container-id\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/instances/{processInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getRequestsByProcessInstance(@Context HttpHeaders headers, @ApiParam(value="identifier of the process instance that asynchornous jobs should be found for", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="optional job status (QUEUED, DONE, CANCELLED, ERROR, RETRYING, RUNNING)", required=false, allowableValues="QUEUED,DONE,CANCELLED,ERROR,RETRYING,RUNNING") @QueryParam(value="status") List<String> statuses, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = this.executorServiceBase.getRequestsByProcessInstance((Number)processInstanceId, statuses, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified job.", response=RequestInfoInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"request-instance-id\": 6,\n  \"request-status\": \"DONE\",\n  \"request-business-key\": \"job3\",\n  \"request-message\": \"Ready to execute\",\n  \"request-retries\": 5,\n  \"request-executions\": 1,\n  \"request-command\": \"org.jbpm.executor.commands.LogCleanupCommand\",\n  \"request-scheduled-date\": {\n    \"java.util.Date\": 1540385144520\n  },\n  \"request-data\": {\n    \"retries\": \"5\",\n    \"businessKey\": \"job3\"\n  },\n  \"response-data\": {\n    \"RequestInfoLogsRemoved\": 2,\n    \"BAMLogRemoved\": 0,\n    \"VariableInstanceLogRemoved\": 0,\n    \"ProcessInstanceLogRemoved\": 0,\n    \"TaskAuditLogRemoved\": 0,\n    \"ErrorInfoLogsRemoved\": 0,\n    \"TaskEventLogRemoved\": 0,\n    \"TaskVariableLogRemoved\": 0,\n    \"NodeInstanceLogRemoved\": 0\n  },\n  \"request-errors\": {\n    \"error-info-instance\": []\n  },\n  \"request-container-id\": null\n}")}))})
    @GET
    @Path(value="{jobId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getRequestById(@Context HttpHeaders headers, @ApiParam(value="identifier of the asynchronous job to be retrieved", required=true, example="123") @PathParam(value="jobId") Long requestId, @ApiParam(value="optional flag that indicats if errors should be loaded as well", required=false) @QueryParam(value="withErrors") boolean withErrors, @ApiParam(value="optional flag that indicats if input/output data should be loaded as well", required=false) @QueryParam(value="withData") boolean withData) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.executorServiceBase.getRequestById(requestId.longValue(), withErrors, withData, type);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

