/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.admin;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.admin.ExecutionErrorNotFoundException;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.TaskNotificationList;
import org.kie.server.api.model.admin.TaskReassignmentList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.remote.rest.jbpm.admin.ProcessAdminResource;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.admin.UserTaskAdminServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/admin/containers/{id}/tasks")
public class UserTaskAdminResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAdminResource.class);
    private UserTaskAdminServiceBase userTaskAdminServiceBase;
    private KieServerRegistry context;
    private static final int POT_OWNER = 1;
    private static final int EXL_OWNER = 2;
    private static final int ADMIN = 3;

    public UserTaskAdminResource() {
    }

    public UserTaskAdminResource(UserTaskAdminServiceBase userTaskAdminServiceBase, KieServerRegistry context) {
        this.userTaskAdminServiceBase = userTaskAdminServiceBase;
        this.context = context;
    }

    @PUT
    @Path(value="{tInstanceId}/pot-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response addPotentialOwners(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 1);
    }

    @PUT
    @Path(value="{tInstanceId}/exl-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response addExcludedOwners(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 2);
    }

    @PUT
    @Path(value="{tInstanceId}/admins")
    @Produces(value={"application/xml", "application/json"})
    public Response addAdmins(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 3);
    }

    @DELETE
    @Path(value="{tInstanceId}/pot-owners/users/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removePotentialOwnersUsers(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 1);
    }

    @DELETE
    @Path(value="{tInstanceId}/exl-owners/users/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeExcludedOwnersUsers(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 2);
    }

    @DELETE
    @Path(value="{tInstanceId}/admins/users/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeAdminsUsers(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 3);
    }

    @DELETE
    @Path(value="{tInstanceId}/pot-owners/groups/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removePotentialOwnersGroups(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 1);
    }

    @DELETE
    @Path(value="{tInstanceId}/exl-owners/groups/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeExcludedOwnersGroups(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 2);
    }

    @DELETE
    @Path(value="{tInstanceId}/admins/groups/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeAdminsGroups(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 3);
    }

    @PUT
    @Path(value="{tInstanceId}/contents/input")
    @Produces(value={"application/xml", "application/json"})
    public Response addTaskInputs(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.addTaskInputs(containerId, (Number)tInstanceId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @DELETE
    @Path(value="{tInstanceId}/contents/input")
    @Produces(value={"application/xml", "application/json"})
    public Response removeTaskInputs(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="name") List<String> inputNames) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.removeTaskInputs(containerId, (Number)tInstanceId, inputNames);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @DELETE
    @Path(value="{tInstanceId}/contents/output")
    @Produces(value={"application/xml", "application/json"})
    public Response removeTaskOutputs(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="name") List<String> inputNames) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.removeTaskOutputs(containerId, (Number)tInstanceId, inputNames);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @POST
    @Path(value="{tInstanceId}/reassignments")
    @Produces(value={"application/xml", "application/json"})
    public Response reassign(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="expiresAt") String expiresAt, @QueryParam(value="whenNotStarted") @DefaultValue(value="false") boolean whenNotStarted, @QueryParam(value="whenNotCompleted") @DefaultValue(value="false") boolean whenNotCompleted, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        if (expiresAt == null) {
            return RestUtils.badRequest((String)"'expiresAt' query parameter is mandatory", (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        try {
            if (!whenNotCompleted && !whenNotStarted) {
                return RestUtils.badRequest((String)"At least one query parameters must be set to true - 'whenNotStarted' or 'whenNotCompleted'", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            String id = null;
            if (whenNotStarted) {
                id = this.userTaskAdminServiceBase.reassignWhenNotStarted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            if (whenNotCompleted) {
                id = this.userTaskAdminServiceBase.reassignWhenNotCompleted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            return RestUtils.createResponse((Object)id, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (RuntimeException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @POST
    @Path(value="{tInstanceId}/notifications")
    @Produces(value={"application/xml", "application/json"})
    public Response notify(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="expiresAt") String expiresAt, @QueryParam(value="whenNotStarted") @DefaultValue(value="false") boolean whenNotStarted, @QueryParam(value="whenNotCompleted") @DefaultValue(value="false") boolean whenNotCompleted, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            if (expiresAt == null) {
                return RestUtils.badRequest((String)"'expiresAt' query parameter is mandatory", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            if (!whenNotCompleted && !whenNotStarted) {
                return RestUtils.badRequest((String)"At least one query parameters must be set to true - 'whenNotStarted' or 'whenNotCompleted'", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            String id = null;
            if (whenNotStarted) {
                id = this.userTaskAdminServiceBase.notifyWhenNotStarted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            if (whenNotCompleted) {
                id = this.userTaskAdminServiceBase.notifyWhenNotCompleted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            return RestUtils.createResponse((Object)id, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @DELETE
    @Path(value="{tInstanceId}/reassignments/{reassignmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelReassignment(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="reassignmentId") Long reassignmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.cancelReassignment(containerId, (Number)tInstanceId, (Number)reassignmentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @DELETE
    @Path(value="{tInstanceId}/notifications/{notificationId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelNotification(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @PathParam(value="notificationId") Long notificationId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.cancelNotification(containerId, (Number)tInstanceId, (Number)notificationId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="{tInstanceId}/reassignments")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskReassignments(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskReassignmentList taskReassignmentList = this.userTaskAdminServiceBase.getTaskReassignments(containerId, (Number)tInstanceId, activeOnly);
            return RestUtils.createCorrectVariant((Object)taskReassignmentList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="{tInstanceId}/notifications")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskNotifications(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long tInstanceId, @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskNotificationList taskNotificationList = this.userTaskAdminServiceBase.getTaskNotifications(containerId, (Number)tInstanceId, activeOnly);
            return RestUtils.createCorrectVariant((Object)taskNotificationList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @PUT
    @Path(value="errors/{errorId}")
    @Produces(value={"application/xml", "application/json"})
    public Response acknowledgeError(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.acknowledgeError(Arrays.asList(errorId));
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @PUT
    @Path(value="errors")
    @Produces(value={"application/xml", "application/json"})
    public Response acknowledgeErrors(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="errorId") List<String> errorIds) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.acknowledgeError(errorIds);
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="errors/{errorId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrorById(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstance executionErrorInstance = this.userTaskAdminServiceBase.getError(errorId);
            return RestUtils.createCorrectVariant((Object)executionErrorInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="{tInstanceId}/errors")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrorsByTask(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.userTaskAdminServiceBase.getExecutionErrorsByTaskId(containerId, (Number)taskId, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="errors")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrors(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @QueryParam(value="name") String taskName, @QueryParam(value="process") String processId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.userTaskAdminServiceBase.getExecutionErrorsByTaskName(containerId, processId, taskName, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected Response addToTask(HttpHeaders headers, String containerId, Long tInstanceId, boolean removeExisting, String payload, int operation) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            switch (operation) {
                case 1: {
                    this.userTaskAdminServiceBase.addPotentialOwners(containerId, (Number)tInstanceId, removeExisting, payload, type);
                    break;
                }
                case 2: {
                    this.userTaskAdminServiceBase.addExcludedOwners(containerId, (Number)tInstanceId, removeExisting, payload, type);
                    break;
                }
                case 3: {
                    this.userTaskAdminServiceBase.addBusinessAdmins(containerId, (Number)tInstanceId, removeExisting, payload, type);
                }
            }
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected Response removeFromTask(HttpHeaders headers, String containerId, Long tInstanceId, boolean isUser, String entities, int operation) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String[] multipleEntities = entities.split(",");
            List<String> listOfEntities = Arrays.asList(multipleEntities);
            switch (operation) {
                case 1: {
                    this.userTaskAdminServiceBase.removePotentialOwners(containerId, (Number)tInstanceId, listOfEntities, isUser);
                    break;
                }
                case 2: {
                    this.userTaskAdminServiceBase.removeExcludedOwners(containerId, (Number)tInstanceId, listOfEntities, isUser);
                    break;
                }
                case 3: {
                    this.userTaskAdminServiceBase.removeBusinessAdmins(containerId, (Number)tInstanceId, listOfEntities, isUser);
                }
            }
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

