/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceCustomVarsList;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.ProcessInstanceUserTaskWithVariablesList;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.marker.KieServerEndpoint;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Process queries")
@Path(value="server/queries")
public class RuntimeDataResource {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeDataResource.class);
    private RuntimeDataServiceBase runtimeDataServiceBase;
    private KieServerRegistry context;

    public RuntimeDataResource() {
    }

    public RuntimeDataResource(RuntimeDataServiceBase delegate, KieServerRegistry context) {
        this.runtimeDataServiceBase = delegate;
        this.context = context;
    }

    @ApiOperation(value="Returns all process instances filtered by optional parameters.", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstances(@Context HttpHeaders headers, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional process instance initiator - user who started process instance to filter process instances", required=false) @QueryParam(value="initiator") String initiator, @ApiParam(value="optional process name to filter process instances", required=false) @QueryParam(value="processName") String processName, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstances(status, initiator, processName, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns all process instances for a specified process.", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/{processId}/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstancesByProcessId(@Context HttpHeaders headers, @ApiParam(value="process id to filter process instance", required=true) @PathParam(value="processId") String processId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optinal process instance initiator - user who started process instance to filtr process instances", required=false) @QueryParam(value="initiator") String initiator, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByProcessId(processId, status, initiator, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns all process instances for a specified KIE container.", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="containers/{containerId}/process/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstancesByDeploymentId(@Context HttpHeaders headers, @ApiParam(value="container id to filter process instance", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByDeploymentId(containerId, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
            return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a single process instance with a specified correlation key.", response=ProcessInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance-id\": 1,\n  \"process-id\": \"Employee_Rostering.Process1\",\n  \"process-name\": \"Process1\",\n  \"process-version\": \"1.0\",\n  \"process-instance-state\": 1,\n  \"container-id\": \"employee-rostering\",\n  \"initiator\": \"baAdmin\",\n  \"start-date\": {\n    \"java.util.Date\": 1539184095041\n  },\n  \"process-instance-desc\": \"Process1\",\n  \"correlation-key\": \"1\",\n  \"parent-instance-id\": -1,\n  \"sla-compliance\": 0,\n  \"sla-due-date\": null,\n  \"active-user-tasks\": null,\n  \"process-instance-variables\": {\n    \"initiator\": \"baAdmin\"\n  }\n}")}))})
    @GET
    @Path(value="processes/instance/correlation/{correlationKey}")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstanceByCorrelationKey(@Context HttpHeaders headers, @ApiParam(value="correlation key associated with process instance", required=true) @PathParam(value="correlationKey") String correlationKey) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstance processInstance = this.runtimeDataServiceBase.getProcessInstanceByCorrelationKey(correlationKey);
        if (processInstance == null) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", correlationKey), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns process instances with a specified correlation key.", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/instances/correlation/{correlationKey}")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstancesByCorrelationKey(@Context HttpHeaders headers, @ApiParam(value="correlation key to filter process instance, can be given as partial correlation key like in starts with approach", required=true) @PathParam(value="correlationKey") String correlationKey, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByCorrelationKey(correlationKey, page, pageSize, sort, sortOrder);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns process instances with a specified variable.", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/instances/variables/{varName}")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstanceByVariables(@Context HttpHeaders headers, @ApiParam(value="variable name to filter process instance", required=true) @PathParam(value="varName") String variableName, @ApiParam(value="variable value to filter process instance, optional when filtering by name only required when filtering by name and value", required=false) @QueryParam(value="varValue") String variableValue, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstanceByVariables(variableName, variableValue, status, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns information about a specified process instance.", response=ProcessInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance-id\": 1,\n  \"process-id\": \"Employee_Rostering.Process1\",\n  \"process-name\": \"Process1\",\n  \"process-version\": \"1.0\",\n  \"process-instance-state\": 1,\n  \"container-id\": \"employee-rostering\",\n  \"initiator\": \"baAdmin\",\n  \"start-date\": {\n    \"java.util.Date\": 1539184095041\n  },\n  \"process-instance-desc\": \"Process1\",\n  \"correlation-key\": \"1\",\n  \"parent-instance-id\": -1,\n  \"sla-compliance\": 0,\n  \"sla-due-date\": null,\n  \"active-user-tasks\": null,\n  \"process-instance-variables\": {\n    \"initiator\": \"baAdmin\"\n  }\n}")}))})
    @GET
    @Path(value="processes/instances/{processInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstanceById(@Context HttpHeaders headers, @ApiParam(value="process instance id to retrieve process instance", required=true) @PathParam(value="processInstanceId") long processInstanceId, @ApiParam(value="load process instance variables or not, defaults to false", required=false) @QueryParam(value="withVars") boolean withVars) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstance processInstanceDesc = null;
        try {
            processInstanceDesc = this.runtimeDataServiceBase.getProcessInstanceById(processInstanceId, withVars);
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processInstanceDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns node instances for a specified work item in a specified process instance.", response=NodeInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Node instance id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"node-instance-id\": 6,\n  \"node-name\": \"Correct Data\",\n  \"process-instance-id\": 7,\n  \"work-item-id\": 9,\n  \"container-id\": \"mortgage-process2\",\n  \"start-date\": {\n    \"java.util.Date\": 1539810634380\n  },\n  \"node-id\": \"_011ED858-F841-4C44-B0F1-F3BE388ADDA5\",\n  \"node-type\": \"HumanTaskNode\",\n  \"node-connection\": null,\n  \"node-completed\": false,\n  \"reference-id\": null,\n  \"sla-compliance\": 0,\n  \"sla-due-date\": null\n}")}))})
    @GET
    @Path(value="processes/instances/{processInstanceId}/wi-nodes/instances/{workItemId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getNodeInstanceForWorkItem(@Context HttpHeaders headers, @ApiParam(value="process instance id that work item belongs to", required=true) @PathParam(value="processInstanceId") long processInstanceId, @ApiParam(value="work item id to retrieve node instance for", required=true) @PathParam(value="workItemId") long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        NodeInstance nodeInstanceDesc = null;
        try {
            nodeInstanceDesc = this.runtimeDataServiceBase.getNodeInstanceForWorkItem(processInstanceId, workItemId);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", workItemId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)nodeInstanceDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns node instances for a specified process instance.", response=NodeInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"node-instance\": [\n    {\n      \"node-instance-id\": 1,\n      \"node-name\": \"Task\",\n      \"process-instance-id\": 2,\n      \"work-item-id\": 2,\n      \"container-id\": \"employee-rostering\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095048\n      },\n      \"node-id\": \"_5F8EED98-433C-4E7B-97BC-0E70615F13CB\",\n      \"node-type\": \"HumanTaskNode\",\n      \"node-connection\": \"_E89FEB0F-B8E1-4138-9DF0-397C9F9A6512\",\n      \"node-completed\": false,\n      \"reference-id\": null,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/instances/{processInstanceId}/nodes/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstanceHistory(@Context HttpHeaders headers, @ApiParam(value="process instance id to to retrive history for", required=true) @PathParam(value="processInstanceId") long processInstanceId, @ApiParam(value="include active nodes only", required=false) @QueryParam(value="activeOnly") Boolean active, @ApiParam(value="include completed nodes only", required=false) @QueryParam(value="completedOnly") Boolean completed, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        NodeInstanceList nodeInstanceList = this.runtimeDataServiceBase.getProcessInstanceHistory(processInstanceId, active, completed, page, pageSize);
        logger.debug("Returning result of node instances search: {}", (Object)nodeInstanceList);
        return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns current variable values of a specified process instance.", response=VariableInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"variable-instance\": [\n    {\n      \"name\": \"initiator\",\n      \"old-value\": \"\",\n      \"value\": \"baAdmin\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610491992\n      }\n    },\n    {\n      \"name\": \"application\",\n      \"old-value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610492006\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/instances/{processInstanceId}/variables/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getVariablesCurrentState(@Context HttpHeaders headers, @ApiParam(value="process instance id to load variables current state (latest value) for", required=true) @PathParam(value="processInstanceId") long processInstanceId) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariablesCurrentState(processInstanceId);
        logger.debug("Returning result of variables search: {}", (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns the history of a specified variable in a specified process instance.", response=VariableInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"variable-instance\": [\n    {\n      \"name\": \"initiator\",\n      \"old-value\": \"\",\n      \"value\": \"baAdmin\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610491992\n      }\n    },\n    {\n      \"name\": \"application\",\n      \"old-value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610492006\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/instances/{processInstanceId}/variables/instances/{varName}")
    @Produces(value={"application/json", "application/xml"})
    public Response getVariableHistory(@Context HttpHeaders headers, @ApiParam(value="process instance id to load variable history for", required=true) @PathParam(value="processInstanceId") long processInstanceId, @ApiParam(value="variable name that history should be loaded for", required=true) @PathParam(value="varName") String variableName, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariableHistory(processInstanceId, variableName, page, pageSize);
        logger.debug("Returning result of variable '{}; history search: {}", (Object)variableName, (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns all process definitions in a specified KIE container.", response=ProcessDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"processes\": [\n    {\n      \"associatedEntities\": null,\n      \"serviceTasks\": null,\n      \"processVariables\": null,\n      \"reusableSubProcesses\": null,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"package\": \"employeerostering.employeerostering\",\n      \"container-id\": \"employee-rostering\",\n      \"dynamic\": false\n    }\n  ]\n}")}))})
    @GET
    @Path(value="containers/{containerId}/processes/definitions")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessesByDeploymentId(@Context HttpHeaders headers, @ApiParam(value="container id to filter process definitions", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesByDeploymentId(containerId, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns all process definitions.", response=ProcessDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"processes\": [\n    {\n      \"associatedEntities\": null,\n      \"serviceTasks\": null,\n      \"processVariables\": null,\n      \"reusableSubProcesses\": null,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"package\": \"employeerostering.employeerostering\",\n      \"container-id\": \"employee-rostering\",\n      \"dynamic\": false\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/definitions")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessesByFilter(@Context HttpHeaders headers, @ApiParam(value="process id or name to filter process definitions", required=false) @QueryParam(value="filter") String filter, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesByFilter(filter, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns all process definitions for a specified process.", response=ProcessDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"processes\": [\n    {\n      \"associatedEntities\": null,\n      \"serviceTasks\": null,\n      \"processVariables\": null,\n      \"reusableSubProcesses\": null,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"package\": \"employeerostering.employeerostering\",\n      \"container-id\": \"employee-rostering\",\n      \"dynamic\": false\n    }\n  ]\n}")}))})
    @GET
    @Path(value="processes/definitions/{processId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessesById(@Context HttpHeaders headers, @ApiParam(value="process id to load process definition", required=true) @PathParam(value="processId") String processId) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesById(processId);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns information about a specified process definition in a specified KIE container.", response=ProcessDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"associatedEntities\": {\n    \"Qualify\": [\n      \"approver\"\n    ],\n    \"Final Approval\": [\n      \"manager\"\n    ],\n    \"Correct Data\": [\n      \"broker\"\n    ],\n    \"Increase Down Payment\": [\n      \"broker\"\n    ]\n  },\n  \"serviceTasks\": {},\n  \"processVariables\": {\n    \"inlimit\": \"Boolean\",\n    \"application\": \"com.myspace.mortgage_app.Application\",\n    \"incdownpayment\": \"Boolean\"\n  },\n  \"reusableSubProcesses\": [],\n  \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n  \"process-name\": \"MortgageApprovalProcess\",\n  \"process-version\": \"1.0\",\n  \"package\": \"com.myspace.mortgage_app\",\n  \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n  \"dynamic\": false\n}")}))})
    @GET
    @Path(value="containers/{containerId}/processes/definitions/{processId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessesByDeploymentIdProcessId(@Context HttpHeaders headers, @ApiParam(value="container id that process definition belongs to", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="process id to load process definition", required=true) @PathParam(value="processId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinition processDesc = null;
        try {
            processDesc = this.runtimeDataServiceBase.getProcessesByDeploymentIdProcessId(containerId, processId);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns task instances with a specified work item.", response=TaskInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task not found for given work item id"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-id\": 1,\n  \"task-priority\": 0,\n  \"task-name\": \"Self Evaluation\",\n  \"task-subject\": null,\n  \"task-description\": \"Please perform a self-evalutation.\",\n  \"task-type\": null,\n  \"task-form\": null,\n  \"task-status\": \"Ready\",\n  \"task-actual-owner\": \"kiesu\",\n  \"task-created-by\": \"Jane\",\n  \"task-created-on\": {\n    \"java.util.Date\": 1539623679113\n  },\n  \"task-activation-time\": {\n    \"java.util.Date\": 1539623679113\n  },\n  \"task-expiration-time\": null,\n  \"task-skippable\": null,\n  \"task-workitem-id\": null,\n  \"task-process-instance-id\": 4,\n  \"task-parent-id\": null,\n  \"task-process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n  \"task-container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n  \"task-pot-owners\": \"Jane\",\n  \"task-excl-owners\": null,\n  \"task-business-admins\": \"John\",\n  \"task-input-data\": null,\n  \"task-output-data\": null\n}")}))})
    @GET
    @Path(value="tasks/instances/workitem/{workItemId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskByWorkItemId(@Context HttpHeaders headers, @ApiParam(value="work item id to load task associated with", required=true) @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        TaskInstance userTaskDesc = null;
        try {
            userTaskDesc = this.runtimeDataServiceBase.getTaskByWorkItemId(workItemId.longValue());
            return RestUtils.createCorrectVariant((Object)userTaskDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance for work item with id \"{0}\"", workItemId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified task instance.", response=TaskInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task not found for given id"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-id\": 1,\n  \"task-priority\": 0,\n  \"task-name\": \"Self Evaluation\",\n  \"task-subject\": null,\n  \"task-description\": \"Please perform a self-evalutation.\",\n  \"task-type\": null,\n  \"task-form\": null,\n  \"task-status\": \"Ready\",\n  \"task-actual-owner\": \"kiesu\",\n  \"task-created-by\": \"Jane\",\n  \"task-created-on\": {\n    \"java.util.Date\": 1539623679113\n  },\n  \"task-activation-time\": {\n    \"java.util.Date\": 1539623679113\n  },\n  \"task-expiration-time\": null,\n  \"task-skippable\": null,\n  \"task-workitem-id\": null,\n  \"task-process-instance-id\": 4,\n  \"task-parent-id\": null,\n  \"task-process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n  \"task-container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n  \"task-pot-owners\": \"Jane\",\n  \"task-excl-owners\": null,\n  \"task-business-admins\": \"John\",\n  \"task-input-data\": null,\n  \"task-output-data\": null\n}")}))})
    @GET
    @Path(value="tasks/instances/{taskInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskById(@Context HttpHeaders headers, @ApiParam(value="task id to load task instance", required=true) @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional include SLA data - defaults to false", required=false) @QueryParam(value="withSLA") @DefaultValue(value="false") boolean withSLA) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskInstance userTaskDesc = this.runtimeDataServiceBase.getTaskById(taskId.longValue(), withSLA);
            return RestUtils.createCorrectVariant((Object)userTaskDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns task instances assigned to business administrators.", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="tasks/instances/admins")
    @Produces(value={"application/json", "application/xml"})
    public Response getTasksAssignedAsBusinessAdministratorByStatus(@Context HttpHeaders headers, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksAssignedAsBusinessAdministratorByStatus(status, userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns tasks with a user defined as a potential owner.", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="tasks/instances/pot-owners")
    @Produces(value={"application/json", "application/xml"})
    public Response getTasksAssignedAsPotentialOwner(@Context HttpHeaders headers, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional group names to include in the query", required=false, allowMultiple=true) @QueryParam(value="groups") List<String> groupIds, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @ApiParam(value="optional custom filter for task data", required=false) @QueryParam(value="filter") String filter) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksAssignedAsPotentialOwner(status, groupIds, userId, page, pageSize, sort, sortOrder, filter);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns task instances that the querying user owns.", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="tasks/instances/owners")
    @Produces(value={"application/json", "application/xml"})
    public Response getTasksOwnedByStatus(@Context HttpHeaders headers, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksOwnedByStatus(status, userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns task instances associated with a specified process instance.", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="tasks/instances/process/{processInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getTasksByStatusByProcessInstanceId(@Context HttpHeaders headers, @ApiParam(value="process instance id to filter task instances", required=true) @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksByStatusByProcessInstanceId((Number)processInstanceId, status, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all task instances.", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="tasks/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getAllAuditTask(@Context HttpHeaders headers, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getAllAuditTask(userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns events for a specified task instance.", response=TaskEventInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-event-instance\": [\n    {\n      \"task-event-id\": 4,\n      \"task-id\": 4,\n      \"task-event-type\": \"STARTED\",\n      \"task-event-user\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"task-event-date\": {\n        \"java.util.Date\": 1539623679130\n      },\n      \"task-process-instance-id\": 4,\n      \"task-work-item-id\": 4,\n      \"task-event-message\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="tasks/instances/{taskInstanceId}/events")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskEvents(@Context HttpHeaders headers, @ApiParam(value="task id to load task events for", required=true) @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskEventInstanceList result = this.runtimeDataServiceBase.getTaskEvents(taskId.longValue(), page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns task instances with a specified variable.", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-summary\": [\n    {\n      \"task-id\": \"2\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"Ready\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:09:14.206+02:00\",\n      \"task-proc-inst-id\": \"2\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    },\n    {\n      \"task-id\": \"1\",\n      \"task-name\": \"Self Evaluation\",\n      \"task-subject\": \"\",\n      \"task-description\": \"Please perform a self-evalutation.\",\n      \"task-status\": \"InProgress\",\n      \"task-priority\": \"0\",\n      \"task-is-skippable\": \"false\",\n      \"task-actual-owner\": \"kiesu\",\n      \"task-created-by\": \"John\",\n      \"task-created-on\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-activation-time\": \"2016-04-05T15:05:06.508+02:00\",\n      \"task-proc-inst-id\": \"1\",\n      \"task-proc-def-id\": \"evaluation\",\n      \"task-container-id\": \"myContainer\",\n      \"task-parent-id\": \"-1\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="tasks/instances/variables/{varName}")
    @Produces(value={"application/json", "application/xml"})
    public Response getTasksByVariables(@Context HttpHeaders headers, @ApiParam(value="name of the variable used to fiter tasks", required=true) @PathParam(value="varName") String variableName, @ApiParam(value="value of the variable used to fiter tasks, optional when filtering only by name, required when filtering by both name and value", required=false) @QueryParam(value="varValue") String variableValue, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksByVariables(userId, variableName, variableValue, status, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Queries processes by variables and tasks")
    @POST
    @Path(value="variables/processes")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT, KieServerEndpoint.EndpointType.HISTORY})
    public Response queryProcessesByVariables(@Context HttpHeaders headers, String payload, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String type = RestUtils.getContentType((HttpHeaders)headers);
            ProcessInstanceCustomVarsList processVariableSummaryList = this.runtimeDataServiceBase.queryProcessesByVariables(payload, type, new QueryContext(Integer.valueOf(page * pageSize), pageSize));
            logger.debug("Returning result of process instance search: {}", (Object)processVariableSummaryList);
            return RestUtils.createCorrectVariant((Object)processVariableSummaryList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Queries process tasks by variables")
    @POST
    @Path(value="variables/processes/tasks")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT, KieServerEndpoint.EndpointType.HISTORY})
    public Response queryUserTasksByVariables(@Context HttpHeaders headers, String payload, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String type = RestUtils.getContentType((HttpHeaders)headers);
            ProcessInstanceUserTaskWithVariablesList taskVariableSummaryList = this.runtimeDataServiceBase.queryUserTasksByVariables(payload, type, new QueryContext(Integer.valueOf(page * pageSize), pageSize));
            logger.debug("Returning result of process tasks search: {}", (Object)taskVariableSummaryList);
            return RestUtils.createCorrectVariant((Object)taskVariableSummaryList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

