/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.admin;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.admin.ExecutionErrorNotFoundException;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.TaskNotificationList;
import org.kie.server.api.model.admin.TaskReassignmentList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.remote.rest.jbpm.admin.ProcessAdminResource;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.admin.UserTaskAdminServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="User tasks administration :: BPM")
@Path(value="server/admin/containers/{id}/tasks")
public class UserTaskAdminResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAdminResource.class);
    private UserTaskAdminServiceBase userTaskAdminServiceBase;
    private KieServerRegistry context;
    private static final int POT_OWNER = 1;
    private static final int EXL_OWNER = 2;
    private static final int ADMIN = 3;

    public UserTaskAdminResource() {
    }

    public UserTaskAdminResource(UserTaskAdminServiceBase userTaskAdminServiceBase, KieServerRegistry context) {
        this.userTaskAdminServiceBase = userTaskAdminServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Adds potential owners to given task instance, optionally removing existing ones", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{tInstanceId}/pot-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response addPotentialOwners(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if existing potential owners should be removed, defaults to false", required=false) @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, @ApiParam(value="list of users/groups to be added as potential owners, as OrgEntities type", required=true) String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 1);
    }

    @ApiOperation(value="Adds excluded owners to given task instance, optionally removing existing ones", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{tInstanceId}/exl-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response addExcludedOwners(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if existing excluded owners should be removed, defaults to false", required=false) @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, @ApiParam(value="list of users/groups to be added as excluded owners, as OrgEntities type", required=true) String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 2);
    }

    @ApiOperation(value="Adds business admins to given task instance, optionally removing existing ones", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{tInstanceId}/admins")
    @Produces(value={"application/xml", "application/json"})
    public Response addAdmins(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if existing business admins should be removed, defaults to false", required=false) @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, @ApiParam(value="list of users/groups to be added as business admins, as OrgEntities type", required=true) String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 3);
    }

    @ApiOperation(value="Removes potential owners from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/pot-owners/users/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removePotentialOwnersUsers(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="list of users to be removed from potantial owners list", required=true) @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 1);
    }

    @ApiOperation(value="Removes excluded owners from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/exl-owners/users/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeExcludedOwnersUsers(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="list of users to be removed from excluded owners list", required=true) @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 2);
    }

    @ApiOperation(value="Removes business admins from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/admins/users/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeAdminsUsers(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="list of users to be removed from business admin list", required=true) @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 3);
    }

    @ApiOperation(value="Removes potential owner groups from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/pot-owners/groups/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removePotentialOwnersGroups(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="list of groups to be removed from potantial owners list", required=true) @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 1);
    }

    @ApiOperation(value="Removes excluded owners groups from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/exl-owners/groups/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeExcludedOwnersGroups(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="list of groups to be removed from excluded owners list", required=true) @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 2);
    }

    @ApiOperation(value="Removes business admin groups from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/admins/groups/{entityId}")
    @Produces(value={"application/xml", "application/json"})
    public Response removeAdminsGroups(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="list of groups to be removed from business admin list", required=true) @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 3);
    }

    @ApiOperation(value="Adds task inputs to given task instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{tInstanceId}/contents/input")
    @Produces(value={"application/xml", "application/json"})
    public Response addTaskInputs(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="map of data to be set as task inputs, as Map", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.addTaskInputs(containerId, (Number)tInstanceId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Removes task inputs referenced by names from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/contents/input")
    @Produces(value={"application/xml", "application/json"})
    public Response removeTaskInputs(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="one or more names of task inputs to be removed", required=true) @QueryParam(value="name") List<String> inputNames) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.removeTaskInputs(containerId, (Number)tInstanceId, inputNames);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Removes task outputs referenced by names from given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/contents/output")
    @Produces(value={"application/xml", "application/json"})
    public Response removeTaskOutputs(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="one or more names of task outputs to be removed", required=true) @QueryParam(value="name") List<String> outputNames) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.removeTaskOutputs(containerId, (Number)tInstanceId, outputNames);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Schedules new reassign of given task instance", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @POST
    @Path(value="{tInstanceId}/reassignments")
    @Produces(value={"application/xml", "application/json"})
    public Response reassign(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="time expression for reassignmnet", required=true) @QueryParam(value="expiresAt") String expiresAt, @ApiParam(value="optional flag that indicates the type of reassignment, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotStarted") @DefaultValue(value="false") boolean whenNotStarted, @ApiParam(value="optional flag that indicates the type of reassignment, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotCompleted") @DefaultValue(value="false") boolean whenNotCompleted, @ApiParam(value="list of users/groups that task should be reassined to, as OrgEntities type", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        if (expiresAt == null) {
            return RestUtils.badRequest((String)"'expiresAt' query parameter is mandatory", (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        try {
            if (!whenNotCompleted && !whenNotStarted) {
                return RestUtils.badRequest((String)"At least one query parameters must be set to true - 'whenNotStarted' or 'whenNotCompleted'", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            String id = null;
            if (whenNotStarted) {
                id = this.userTaskAdminServiceBase.reassignWhenNotStarted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            if (whenNotCompleted) {
                id = this.userTaskAdminServiceBase.reassignWhenNotCompleted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            return RestUtils.createResponse((Object)id, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (RuntimeException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Schedules new notification for given task instance", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @POST
    @Path(value="{tInstanceId}/notifications")
    @Produces(value={"application/xml", "application/json"})
    public Response notify(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="time expression for notification", required=true) @QueryParam(value="expiresAt") String expiresAt, @ApiParam(value="optional flag that indicates the type of notification, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotStarted") @DefaultValue(value="false") boolean whenNotStarted, @ApiParam(value="optional flag that indicates the type of notification, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotCompleted") @DefaultValue(value="false") boolean whenNotCompleted, @ApiParam(value="email notification details, as EmailNotification type", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            if (expiresAt == null) {
                return RestUtils.badRequest((String)"'expiresAt' query parameter is mandatory", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            if (!whenNotCompleted && !whenNotStarted) {
                return RestUtils.badRequest((String)"At least one query parameters must be set to true - 'whenNotStarted' or 'whenNotCompleted'", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            String id = null;
            if (whenNotStarted) {
                id = this.userTaskAdminServiceBase.notifyWhenNotStarted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            if (whenNotCompleted) {
                id = this.userTaskAdminServiceBase.notifyWhenNotCompleted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            return RestUtils.createResponse((Object)id, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Cancels reassignment for given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/reassignments/{reassignmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelReassignment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="identifier of reassignment to be canceled", required=true) @PathParam(value="reassignmentId") Long reassignmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.cancelReassignment(containerId, (Number)tInstanceId, (Number)reassignmentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Cancels notification for given task instance", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{tInstanceId}/notifications/{notificationId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelNotification(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="identifier of notification to be canceled", required=true) @PathParam(value="notificationId") Long notificationId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.cancelNotification(containerId, (Number)tInstanceId, (Number)notificationId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves reassignments for given task", response=TaskReassignmentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @GET
    @Path(value="{tInstanceId}/reassignments")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskReassignments(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if active only reassignmnets should be collected, defaults to true", required=false) @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskReassignmentList taskReassignmentList = this.userTaskAdminServiceBase.getTaskReassignments(containerId, (Number)tInstanceId, activeOnly);
            return RestUtils.createCorrectVariant((Object)taskReassignmentList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves notifications for given task", response=TaskNotificationList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @GET
    @Path(value="{tInstanceId}/notifications")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskNotifications(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="tInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if active only notifications should be collected, defaults to true", required=false) @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskNotificationList taskNotificationList = this.userTaskAdminServiceBase.getTaskNotifications(containerId, (Number)tInstanceId, activeOnly);
            return RestUtils.createCorrectVariant((Object)taskNotificationList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledges given execution error", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="errors/{errorId}")
    @Produces(value={"application/xml", "application/json"})
    public Response acknowledgeError(@Context HttpHeaders headers, @ApiParam(value="container id that error belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the execution error to be acknowledged", required=true) @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.acknowledgeError(Arrays.asList(errorId));
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledges given execution errors", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="errors")
    @Produces(value={"application/xml", "application/json"})
    public Response acknowledgeErrors(@Context HttpHeaders headers, @ApiParam(value="container id that errors belong to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="list of identifiers of execution errors to be acknowledged", required=true) @QueryParam(value="errorId") List<String> errorIds) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.acknowledgeError(errorIds);
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieve execution error by its identifier", response=ExecutionErrorInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @GET
    @Path(value="errors/{errorId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrorById(@Context HttpHeaders headers, @ApiParam(value="container id that error belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the execution error to load", required=true) @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstance executionErrorInstance = this.userTaskAdminServiceBase.getError(errorId);
            return RestUtils.createCorrectVariant((Object)executionErrorInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves execution errors for task instance and container, applies pagination", response=ExecutionErrorInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found")})
    @GET
    @Path(value="{tInstanceId}/errors")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrorsByTask(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that errors should be collected for", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.userTaskAdminServiceBase.getExecutionErrorsByTaskId(containerId, (Number)taskId, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves execution errors for container, allows to filter by task name and/or process id, applies pagination", response=ExecutionErrorInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found")})
    @GET
    @Path(value="errors")
    @Produces(value={"application/xml", "application/json"})
    public Response getExecutionErrors(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional name of the task to filter by", required=false) @QueryParam(value="name") String taskName, @ApiParam(value="optional process id that the task belongs to to filter by", required=false) @QueryParam(value="process") String processId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.userTaskAdminServiceBase.getExecutionErrorsByTaskName(containerId, processId, taskName, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected Response addToTask(HttpHeaders headers, String containerId, Long tInstanceId, boolean removeExisting, String payload, int operation) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            switch (operation) {
                case 1: {
                    this.userTaskAdminServiceBase.addPotentialOwners(containerId, (Number)tInstanceId, removeExisting, payload, type);
                    break;
                }
                case 2: {
                    this.userTaskAdminServiceBase.addExcludedOwners(containerId, (Number)tInstanceId, removeExisting, payload, type);
                    break;
                }
                case 3: {
                    this.userTaskAdminServiceBase.addBusinessAdmins(containerId, (Number)tInstanceId, removeExisting, payload, type);
                }
            }
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected Response removeFromTask(HttpHeaders headers, String containerId, Long tInstanceId, boolean isUser, String entities, int operation) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String[] multipleEntities = entities.split(",");
            List<String> listOfEntities = Arrays.asList(multipleEntities);
            switch (operation) {
                case 1: {
                    this.userTaskAdminServiceBase.removePotentialOwners(containerId, (Number)tInstanceId, listOfEntities, isUser);
                    break;
                }
                case 2: {
                    this.userTaskAdminServiceBase.removeExcludedOwners(containerId, (Number)tInstanceId, listOfEntities, isUser);
                    break;
                }
                case 3: {
                    this.userTaskAdminServiceBase.removeBusinessAdmins(containerId, (Number)tInstanceId, listOfEntities, isUser);
                }
            }
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

