/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.TaskNotFoundException;
import org.kie.server.api.model.instance.TaskAttachment;
import org.kie.server.api.model.instance.TaskAttachmentList;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskCommentList;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.kie.server.services.jbpm.UserTaskServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="User task operations and queries :: BPM")
@Path(value="server/containers/{id}/tasks")
public class UserTaskResource {
    public static final Logger logger = LoggerFactory.getLogger(UserTaskResource.class);
    private UserTaskServiceBase userTaskServiceBase;
    private RuntimeDataServiceBase runtimeDataServiceBase;
    private KieServerRegistry context;

    public UserTaskResource() {
    }

    public UserTaskResource(UserTaskServiceBase userTaskServiceBase, RuntimeDataServiceBase runtimeDataServiceBase, KieServerRegistry context) {
        this.userTaskServiceBase = userTaskServiceBase;
        this.runtimeDataServiceBase = runtimeDataServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Activates task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/activated")
    @Produces(value={"application/xml", "application/json"})
    public Response activate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be activated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.activate(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Claims task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/claimed")
    @Produces(value={"application/xml", "application/json"})
    public Response claim(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be claimed", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.claim(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Completes task with given id that belongs to given container, optionally it can claim and start task when auto-progress is used", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/completed")
    @Produces(value={"application/xml", "application/json"})
    public Response complete(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be completed", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional flag that allows to directlu claim and start task (if needed) before completion", required=false) @QueryParam(value="auto-progress") boolean autoProgress, @ApiParam(value="optional map of output variables", required=false) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            if (autoProgress) {
                this.userTaskServiceBase.completeAutoProgress(containerId, (Number)taskId, userId, payload, type);
            } else {
                this.userTaskServiceBase.complete(containerId, (Number)taskId, userId, payload, type);
            }
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Delegates task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/delegated")
    @Produces(value={"application/xml", "application/json"})
    public Response delegate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be delegated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="user that task should be dalegated to", required=true) @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.delegate(containerId, (Number)taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Exists task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/exited")
    @Produces(value={"application/xml", "application/json"})
    public Response exit(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be exited", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.exit(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Fails task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/failed")
    @Produces(value={"application/xml", "application/json"})
    public Response fail(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be failed", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional map of output variables", required=false) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.fail(containerId, (Number)taskId, userId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Forwards task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/forwarded")
    @Produces(value={"application/xml", "application/json"})
    public Response forward(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be forwarded", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="user that the task should be forwarded to", required=true) @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.forward(containerId, (Number)taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Releases task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/released")
    @Produces(value={"application/xml", "application/json"})
    public Response release(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be released", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.release(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Resumes task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/resumed")
    @Produces(value={"application/xml", "application/json"})
    public Response resume(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be resumed", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.resume(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Skips task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/skipped")
    @Produces(value={"application/xml", "application/json"})
    public Response skip(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be skipped", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.skip(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Starts task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/started")
    @Produces(value={"application/xml", "application/json"})
    public Response start(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be started", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.start(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Stops task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/stopped")
    @Produces(value={"application/xml", "application/json"})
    public Response stop(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be stopped", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.stop(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Suspends task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/suspended")
    @Produces(value={"application/xml", "application/json"})
    public Response suspend(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be suspended", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.suspend(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Nominates task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/states/nominated")
    @Produces(value={"application/xml", "application/json"})
    public Response nominate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be nominated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="list of users that the task should be nominated to", required=true) @QueryParam(value="potOwner") List<String> potentialOwners) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.nominate(containerId, (Number)taskId, userId, potentialOwners);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Sets priority on task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/priority")
    @Produces(value={"application/xml", "application/json"})
    public Response setPriority(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance where priority should be updated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="priority as Integer", required=true) String priorityPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setPriority(containerId, (Number)taskId, priorityPayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Sets expiration date on task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/expiration")
    @Produces(value={"application/xml", "application/json"})
    public Response setExpirationDate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance where expiration date should be updated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="expiration date as Date", required=true) String datePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setExpirationDate(containerId, (Number)taskId, datePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Sets skipable flag on task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/skipable")
    @Produces(value={"application/xml", "application/json"})
    public Response setSkipable(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance where skipable flag should be updated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="skipable flag as Boolean", required=true) String skipablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setSkipable(containerId, (Number)taskId, skipablePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Sets name on task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/name")
    @Produces(value={"application/xml", "application/json"})
    public Response setName(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance where name should be updated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="name as String", required=true) String namePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setName(containerId, (Number)taskId, namePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Sets description on task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/description")
    @Produces(value={"application/xml", "application/json"})
    public Response setDescription(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance where description should be updated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="description as String", required=true) String descriptionPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setDescription(containerId, (Number)taskId, descriptionPayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Saves content on task with given id that belongs to given container", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}/contents/output")
    @Produces(value={"application/xml", "application/json"})
    public Response saveContent(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that data should be saved into", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="output data to be saved as Map ", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.saveContent(containerId, (Number)taskId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves output date from task with given id that belongs to given container", response=Map.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/contents/output")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskOutputContentByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that output data should be loaded from", required=true) @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTaskOutputContentByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves input date from task with given id that belongs to given container", response=Map.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/contents/input")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskInputContentByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that input data should be loaded from", required=true) @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTaskInputContentByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes content from task with given id that belongs to given container", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @DELETE
    @Path(value="{tInstanceId}/contents/{contentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteContent(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that content belongs to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="identifier of the content to be deleted", required=true) @PathParam(value="contentId") Long contentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteContent(containerId, (Number)taskId, (Number)contentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Adds comment to task with given id that belongs to given container", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @POST
    @Path(value="{tInstanceId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response addComment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that comment should be added to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="comment data as TaskComment", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.addComment(containerId, (Number)taskId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes comment from task with given id that belongs to given container", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @DELETE
    @Path(value="{tInstanceId}/comments/{commentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteComment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that comment belongs to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="identifier of the comment to be deleted", required=true) @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteComment(containerId, (Number)taskId, (Number)commentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves comments from task with given id that belongs to given container", response=TaskCommentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/comments")
    @Produces(value={"application/xml", "application/json"})
    public Response getCommentsByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that comments should be loaded for", required=true) @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getCommentsByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves comment with given id from task with given id that belongs to given container", response=TaskComment.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/comments/{commentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCommentById(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that comment belongs to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="identifier of the comment to be loaded", required=true) @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getCommentById(containerId, (Number)taskId, (Number)commentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Adds attachment to task with given id that belongs to given container", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @POST
    @Path(value="{tInstanceId}/attachments")
    @Produces(value={"application/xml", "application/json"})
    public Response addAttachment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that attachment should be added to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="name of the attachment to be added", required=true) @QueryParam(value="name") String name, @ApiParam(value="attachment content, any type can be provided", required=true) String attachmentPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.addAttachment(containerId, (Number)taskId, userId, name, attachmentPayload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes attachment from task with given id that belongs to given container", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @DELETE
    @Path(value="{tInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteAttachment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that attachment belongs to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="identifier of the attachment to be deleted", required=true) @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteAttachment(containerId, (Number)taskId, (Number)attachmentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves attachment with given id from task with given id that belongs to given container", response=TaskAttachment.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentById(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that attachment belongs to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="identifier of the attachment to be loaded", required=true) @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentById(containerId, (Number)taskId, (Number)attachmentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves attachment's content with given id from task with given id that belongs to given container", response=Object.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/attachments/{attachmentId}/content")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentContentById(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that attachment belongs to", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="identifier of the attachment that content should be loaded from", required=true) @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentContentById(containerId, (Number)taskId, (Number)attachmentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves attachments from task with given id that belongs to given container", response=TaskAttachmentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/attachments")
    @Produces(value={"application/xml", "application/json"})
    public Response getAttachmentsByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that attachments should be loaded for", required=true) @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentsByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves task with given id that belongs to given container, optionally loads its input, output data and assignments", response=TaskInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTask(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be loaded", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optionally loads task input data", required=false) @QueryParam(value="withInputData") boolean withInput, @ApiParam(value="optionally loads task output data", required=false) @QueryParam(value="withOutputData") boolean withOutput, @ApiParam(value="optionally loads task people assignments", required=false) @QueryParam(value="withAssignments") boolean withAssignments) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTask(containerId, (Number)taskId, withInput, withOutput, withAssignments, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves task events for given task id and applies pagination", response=TaskEventInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @GET
    @Path(value="{tInstanceId}/events")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskEvents(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that events should be loaded for", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskEventInstanceList result = this.runtimeDataServiceBase.getTaskEvents(taskId.longValue(), page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates task with given id that belongs to given container with given task instance details in body, updates name, description, priority, expiration date, form name, input and output variables", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response update(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the task instance that should be updated", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="task instance with updates as TaskInstance type", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.update(containerId, (Number)taskId, userId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

