/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.optaplanner;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.MessageFormat;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.optaplanner.SolverServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Planning and solvers :: BRP")
@Path(value="server/containers/{id}/solvers")
public class SolverResource {
    public static final Logger logger = LoggerFactory.getLogger(SolverResource.class);
    private SolverServiceBase solverService;
    private MarshallerHelper marshallerHelper;

    public SolverResource() {
    }

    public SolverResource(SolverServiceBase solverServiceBase) {
        this.solverService = solverServiceBase;
        this.marshallerHelper = new MarshallerHelper(this.solverService.getKieServerRegistry());
    }

    @ApiOperation(value="Creates solver within given container", response=SolverInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="Container does not exist or failure in creating solver")})
    @PUT
    @Path(value="{solverId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createSolver(@Context HttpHeaders headers, @ApiParam(value="container id where the solver config resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver to create", required=true) @PathParam(value="solverId") String solverId, @ApiParam(value="solver instance details as SolverInstance type", required=true) String payload) {
        logger.debug("About to create solver {} on container {}", (Object)solverId, (Object)containerId);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            String contentType = RestUtils.getContentType((HttpHeaders)headers);
            if (this.solverService.getKieServerRegistry().getContainer(containerId) == null) {
                ServiceResponse response = new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Failed to create solver. Container does not exist: " + containerId);
                return RestUtils.createCorrectVariant((Object)response, (HttpHeaders)headers, (Response.Status)Response.Status.BAD_REQUEST, (Header[])new Header[0]);
            }
            SolverInstance solverInstance = (SolverInstance)this.marshallerHelper.unmarshal(containerId, payload, contentType, SolverInstance.class);
            ServiceResponse response = this.solverService.createSolver(containerId, solverId, solverInstance);
            if (response.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)response.getResult(), (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)response.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.BAD_REQUEST, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error creating solver '{}' on container '{}': {}", new Object[]{solverId, containerId, e.getMessage(), e});
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves solvers from given container", response=SolverInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container does not exist or failure in creating solver")})
    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getSolvers(@Context HttpHeaders headers, @ApiParam(value="container id where the solvers reside", required=true) @PathParam(value="id") String containerId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.solverService.getSolvers(containerId);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getResult(), (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error retrieving solvers. Message: '{}'", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves solver by its identifier from given container", response=SolverInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container does not exist or failure in creating solver")})
    @GET
    @Path(value="{solverId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getSolver(@Context HttpHeaders headers, @ApiParam(value="container id where the solver resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver", required=true) @PathParam(value="solverId") String solverId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.solverService.getSolver(containerId, solverId);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getResult(), (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error retrieving solver state {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves best solution from solver within container", response=SolverInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container does not exist or failure in creating solver")})
    @GET
    @Path(value="{solverId}/bestsolution")
    @Produces(value={"application/xml", "application/json"})
    public Response getSolverWithBestSolution(@Context HttpHeaders headers, @ApiParam(value="container id where the solver resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver", required=true) @PathParam(value="solverId") String solverId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.solverService.getSolverWithBestSolution(containerId, solverId);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getResult(), (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Solves given planning problem with given solver", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container does not exist or failure in creating solver")})
    @POST
    @Path(value="{solverId}/state/solving")
    @Produces(value={"application/xml", "application/json"})
    public Response solvePlanningProblem(@Context HttpHeaders headers, @ApiParam(value="container id where the solver resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver", required=true) @PathParam(value="solverId") String solverId, @ApiParam(value="planning problem", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            String contentType = RestUtils.getContentType((HttpHeaders)headers);
            Object planningProblem = this.marshallerHelper.unmarshal(containerId, payload, contentType, Object.class);
            ServiceResponse result = this.solverService.solvePlanningProblem(containerId, solverId, planningProblem);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.BAD_REQUEST, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error retrieving solver state {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Terminates early running solver with given id within container", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="Container does not exist or failure in creating solver")})
    @POST
    @Path(value="{solverId}/state/terminating-early")
    @Produces(value={"application/xml", "application/json"})
    public Response terminateSolverEarly(@Context HttpHeaders headers, @ApiParam(value="container id where the solver resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver", required=true) @PathParam(value="solverId") String solverId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.solverService.terminateSolverEarly(containerId, solverId);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.BAD_REQUEST, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error retrieving solver state {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Adds problem fact changes to given solver", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="Container does not exist or failure in creating solver")})
    @POST
    @Path(value="{solverId}/problemfactchanges")
    @Produces(value={"application/xml", "application/json"})
    public Response addProblemFactChanges(@Context HttpHeaders headers, @ApiParam(value="container id where the solver resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver", required=true) @PathParam(value="solverId") String solverId, @ApiParam(value="Problem fact changes, either single one or a list of them", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            String contentType = RestUtils.getContentType((HttpHeaders)headers);
            Object problemFactChange = this.marshallerHelper.unmarshal(containerId, payload, contentType, Object.class);
            ServiceResponse result = this.solverService.addProblemFactChanges(containerId, solverId, problemFactChange);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.BAD_REQUEST, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error retrieving solver state {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves status if problem fact changes have been processed in given solver", response=Boolean.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container does not exist or failure in creating solver")})
    @GET
    @Path(value="{solverId}/problemfactchanges/processed")
    @Produces(value={"application/xml", "application/json"})
    public Response isEveryProblemFactChangeProcessed(@Context HttpHeaders headers, @ApiParam(value="container id where the solver resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver", required=true) @PathParam(value="solverId") String solverId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.solverService.isEveryProblemFactChangeProcessed(containerId, solverId);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getResult(), (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error querying problem facts processing state {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Disposes given solver", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container does not exist or failure in creating solver")})
    @DELETE
    @Path(value="{solverId}")
    @Produces(value={"application/xml", "application/json"})
    public Response disposeSolver(@Context HttpHeaders headers, @ApiParam(value="container id where the solver resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of the solver", required=true) @PathParam(value="solverId") String solverId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.solverService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.solverService.disposeSolver(containerId, solverId);
            if (result.getType() == ServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result.getMsg(), (HttpHeaders)headers, (Response.Status)Response.Status.BAD_REQUEST, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error disposing solver {} on container {}. Message: '{}'", new Object[]{solverId, containerId, e.getMessage(), e});
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

