/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.ContainerInfo;

public class Configuration {
    private Map<String, Set<String>> hostsPerServer = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, Set<String>> hostsPerContainer = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, Set<ContainerInfo>> containerInfosPerContainer = new ConcurrentHashMap<String, Set<ContainerInfo>>();
    private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();

    public Map<String, Set<String>> getHostsPerServer() {
        return this.hostsPerServer;
    }

    public Map<String, Set<String>> getHostsPerContainer() {
        return this.hostsPerContainer;
    }

    public Map<String, Set<ContainerInfo>> getContainerInfosPerContainer() {
        return this.containerInfosPerContainer;
    }

    public void addContainerHost(String containerId, String serverUrl) {
        Set<String> hosts = this.hostsPerContainer.get(containerId);
        if (hosts == null) {
            hosts = new LinkedHashSet<String>();
            this.hostsPerContainer.put(containerId, hosts);
        }
        hosts.add(serverUrl);
        this.listeners.forEach(l -> l.onContainerAdded(containerId, serverUrl));
    }

    public void addServerHost(String serverId, String serverUrl) {
        Set<String> hosts = this.hostsPerServer.get(serverId);
        if (hosts == null) {
            hosts = new LinkedHashSet<String>();
            this.hostsPerServer.put(serverId, hosts);
        }
        hosts.add(serverUrl);
        this.listeners.forEach(l -> l.onServerAdded(serverId, serverUrl));
    }

    public void addContainerInfo(ContainerInfo containerInfo) {
        Set<ContainerInfo> containersByAlias = this.containerInfosPerContainer.get(containerInfo.getAlias());
        if (containersByAlias == null) {
            containersByAlias = new LinkedHashSet<ContainerInfo>();
            this.containerInfosPerContainer.put(containerInfo.getAlias(), containersByAlias);
        }
        containersByAlias.add(containerInfo);
        Set<ContainerInfo> containersById = this.containerInfosPerContainer.get(containerInfo.getContainerId());
        if (containersById == null) {
            containersById = new LinkedHashSet<ContainerInfo>();
            this.containerInfosPerContainer.put(containerInfo.getContainerId(), containersById);
        }
        containersById.add(containerInfo);
    }

    public void removeContainerHost(String containerId, String serverUrl) {
        Set<String> hosts = this.hostsPerContainer.get(containerId);
        if (hosts != null) {
            hosts.remove(serverUrl);
        }
        this.listeners.forEach(l -> l.onContainerRemoved(containerId, serverUrl));
    }

    public void removeServerHost(String serverId, String serverUrl) {
        Set<String> hosts = this.hostsPerServer.get(serverId);
        if (hosts != null) {
            hosts.remove(serverUrl);
        }
        this.listeners.forEach(l -> l.onServerRemoved(serverId, serverUrl));
    }

    public void removeContainerInfo(String containerId, String alias) {
        Set hosts = this.hostsPerContainer.getOrDefault(containerId, Collections.emptySet());
        if (hosts.isEmpty()) {
            this.containerInfosPerContainer.remove(containerId);
        }
        if ((hosts = this.hostsPerContainer.getOrDefault(alias, Collections.emptySet())).isEmpty()) {
            this.containerInfosPerContainer.remove(alias);
        }
    }

    public void addListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "{hostsPerServer=" + this.hostsPerServer + ", hostsPerContainer=" + this.hostsPerContainer + "}";
    }
}

