/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.File;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.Configuration;
import org.kie.server.router.repository.FileRepository;

public class FileRepositoryTest {
    @Test
    public void testStoreAndLoad() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        FileRepository repo = new FileRepository(new File("target"));
        repo.persist(config);
        Configuration loaded = repo.load();
        Assert.assertNotNull((Object)loaded);
        Assert.assertNotNull((Object)loaded.getHostsPerContainer());
        Assert.assertNotNull((Object)loaded.getHostsPerServer());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((Set)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((Set)loaded.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((Set)loaded.getHostsPerContainer().get("container1")).iterator().next());
        Assert.assertEquals((Object)"http://localhost:8180/server", ((Set)loaded.getHostsPerContainer().get("container2")).iterator().next());
        Assert.assertEquals((long)1L, (long)((Set)loaded.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((Set)loaded.getHostsPerServer().get("server2")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((Set)loaded.getHostsPerServer().get("server1")).iterator().next());
        Assert.assertEquals((Object)"http://localhost:8180/server", ((Set)loaded.getHostsPerServer().get("server2")).iterator().next());
    }
}

