/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.kie.server.router.Configuration;
import org.kie.server.router.repository.ConfigurationMarshaller;

public class FileRepository {
    private final File repositoryDir;
    private ConfigurationMarshaller marshaller = new ConfigurationMarshaller();

    public FileRepository() {
        this(new File(System.getProperty("org.kie.server.router.repo", ".")));
    }

    public FileRepository(File repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Configuration configuration) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.repositoryDir, "kie-server-router.json"));
            String config = this.marshaller.marshall(configuration);
            PrintWriter writer = new PrintWriter(fos);
            writer.write(config);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration load() {
        Configuration configuration2 = new Configuration();
        File serverStateFile = new File(this.repositoryDir, "kie-server-router.json");
        if (!serverStateFile.exists()) return null;
        try (FileReader reader = new FileReader(serverStateFile);){
            Configuration configuration = configuration2 = this.marshaller.unmarshall(reader);
            return configuration;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void clean() {
        this.persist(new Configuration());
    }
}

