/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggregate;

import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.proxy.aggragate.XstreamXMLResponseAggregator;
import org.kie.server.router.proxy.aggregate.AbstractAggregateTest;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XstreamAggregatorTest
extends AbstractAggregateTest {
    private static final Logger logger = Logger.getLogger(XstreamAggregatorTest.class);

    @Test
    public void testAggregateProcessDefinitions() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)5L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessDefinitionsTargetEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-empty.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessDefinitionsSourceEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)3L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessDefinitionsEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-empty.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)0L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessInstances() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstanceList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList instances = xml.getElementsByTagName("processInstances");
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)3L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateProcessInstancesTargetEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-empty.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstanceList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList instances = xml.getElementsByTagName("processInstances");
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateProcessInstancesSourceEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstanceList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList instances = xml.getElementsByTagName("processInstances");
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateProcessInstancesEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-instance-empty.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstanceList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList instances = xml.getElementsByTagName("processInstances");
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.ProcessInstance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)0L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummaries() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummaryList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList tasks = xml.getElementsByTagName("tasks");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)5L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummariesTargetEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-empty.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummaryList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList tasks = xml.getElementsByTagName("tasks");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)3L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummariesSourceEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummaryList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList tasks = xml.getElementsByTagName("tasks");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummariesEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/task-summary-empty.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummaryList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList tasks = xml.getElementsByTagName("tasks");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.getLength());
        NodeList processInstances = xml.getElementsByTagName("org.kie.server.api.model.instance.TaskSummary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)0L, (long)processInstances.getLength());
    }

    @Test
    public void testSortProcessDefinitions() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(0), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"1", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"2", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsDescending() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", false, Integer.valueOf(0), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"5", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"4", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsNextPage() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(1), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"3", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"4", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsNextPageDescending() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", false, Integer.valueOf(1), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"3", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"2", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsOutOfPage() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/process-def-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(5), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinitionList");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("org.kie.server.api.model.definition.ProcessDefinition");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)0L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateContainers() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/xstream/containers-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/xstream/containers-2.xml"));
        XstreamXMLResponseAggregator aggregate = new XstreamXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("org.kie.server.api.model.ServiceResponse");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList defs = xml.getElementsByTagName("result");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.getLength());
        NodeList processDefs = xml.getElementsByTagName("kie-container");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)6L, (long)processDefs.getLength());
    }
}

