/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;

public abstract class AbstractAggregateHttpHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(AbstractAggregateHttpHandler.class);
    private static final String REPLACE_PAGE = "page=[^&]*";
    private static final String REPLACE_PAGE_SIZE = "pageSize=[^&]*";
    private static final String DEFAULT_ACCEPT = "application/xml";
    private HttpHandler httpHandler;
    private AdminHttpHandler adminHandler;
    private RoundRobinHostSelector selector = new RoundRobinHostSelector();

    public AbstractAggregateHttpHandler(HttpHandler httpHandler, AdminHttpHandler adminHandler) {
        this.httpHandler = httpHandler;
        this.adminHandler = adminHandler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Deque<String> originalSortOrder;
        Deque<String> originalPageSize;
        if (!exchange.getRequestMethod().equals(HttpString.tryFromString("GET"))) {
            this.httpHandler.handleRequest(exchange);
        }
        Map<String, Deque<String>> queryParams = exchange.getQueryParameters();
        Integer page = 0;
        Integer pageSize = 10;
        Deque<String> originalPage = queryParams.get("page");
        if (originalPage != null && !originalPage.isEmpty()) {
            page = Integer.parseInt(originalPage.getFirst());
        }
        if ((originalPageSize = queryParams.remove("pageSize")) != null && !originalPageSize.isEmpty()) {
            pageSize = Integer.parseInt(originalPageSize.getFirst());
        }
        String routerPage = "0";
        String routerPageSize = String.valueOf((1 + page) * pageSize);
        String sortBy = null;
        boolean sortOder = true;
        Deque<String> originalSortBy = queryParams.get("sort");
        if (originalSortBy != null && !originalSortBy.isEmpty()) {
            sortBy = originalSortBy.getFirst();
        }
        if ((originalSortOrder = queryParams.get("sortOrder")) != null && !originalSortOrder.isEmpty()) {
            sortOder = Boolean.parseBoolean(originalSortOrder.getFirst());
        }
        ConcurrentHashMap<String, List> responseHeaders = new ConcurrentHashMap<String, List>();
        List<String> returnResponses = this.getServerHosts().parallelStream().map(url -> {
            String response = null;
            try {
                response = this.sendRequest((String)url, exchange, (Map<String, List<String>>)responseHeaders, "0", routerPageSize);
            }
            catch (Exception e) {
                log.error((Object)"Error when forwarding request to server", e);
            }
            return response;
        }).filter(msg -> msg != null && !msg.trim().isEmpty()).collect(Collectors.toList());
        if (returnResponses.isEmpty()) {
            ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
            return;
        }
        HeaderValues accept = exchange.getRequestHeaders().get(Headers.ACCEPT);
        HeaderValues kieContentType = exchange.getRequestHeaders().get("X-KIE-ContentType");
        ResponseAggregator responseAggregator = this.adminHandler.getAggregators().stream().filter(a -> a.supports(kieContentType, accept, DEFAULT_ACCEPT)).findFirst().orElseThrow(() -> new RuntimeException("not possible to find response aggregator for " + responseHeaders.get(Headers.ACCEPT)));
        String response = null;
        response = this.supportAdvancedAggregate() ? responseAggregator.aggregate(returnResponses, sortBy, sortOder, page, pageSize) : responseAggregator.aggregate(returnResponses);
        responseHeaders.forEach((name, value) -> exchange.getResponseHeaders().putAll(HttpString.tryFromString(name), (Collection<String>)value));
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, response.getBytes("UTF-8").length);
        exchange.getResponseSender().send(response);
    }

    protected String sendRequest(String url, HttpServerExchange exchange, Map<String, List<String>> responseHeaders, String page, String pageSize) throws Exception {
        String inputLine;
        URL obj = new URL(url + exchange.getRequestPath() + "?" + exchange.getQueryString().replaceAll(REPLACE_PAGE, "page=" + page).replaceAll(REPLACE_PAGE_SIZE, "pageSize=" + pageSize));
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        exchange.getRequestHeaders().forEach(h -> con.setRequestProperty(h.getHeaderName().toString(), h.getFirst()));
        log.debugf("Sending 'GET' request to URL : %s", (Object)obj);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        Map<String, List<String>> headers = con.getHeaderFields();
        headers.forEach((k, v) -> {
            if (k != null) {
                responseHeaders.put((String)k, (List<String>)v);
            }
        });
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    protected Set<String> getServerHosts() {
        return this.adminHandler.getHostsPerServer().values().stream().map(hosts -> this.selector.selectHost(hosts.toArray(new String[hosts.size()]))).collect(Collectors.toSet());
    }

    protected boolean supportAdvancedAggregate() {
        return true;
    }

    static class RoundRobinHostSelector {
        private final AtomicInteger currentHost = new AtomicInteger(0);

        RoundRobinHostSelector() {
        }

        public String selectHost(String[] availableHosts) {
            int hostIndex = this.currentHost.incrementAndGet() % availableHosts.length;
            return availableHosts[hostIndex];
        }
    }
}

